/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.testcontainers;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class ConvertToRawType
extends Recipe {
    @Option(displayName="Fully qualified type name", description="The fully qualified name of the Java class to convert to its raw type.", example="org.testcontainers.containers.PostgreSQLContainer")
    private final String fullyQualifiedTypeName;
    private final String displayName = "Remove parameterized type arguments from a Java class";
    private final String description = "Convert parameterized types of a specified Java class to their raw types.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(this.fullyQualifiedTypeName, Boolean.valueOf(false)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public @Nullable JavaType visitType(@Nullable JavaType javaType, ExecutionContext ctx) {
                if (javaType instanceof JavaType.Parameterized) {
                    JavaType.FullyQualified rawType = ((JavaType.Parameterized)javaType).getType();
                    if (TypeUtils.isAssignableTo((String)ConvertToRawType.this.fullyQualifiedTypeName, (JavaType)rawType)) {
                        return rawType;
                    }
                }
                return super.visitType(javaType, (Object)ctx);
            }

            public J visitParameterizedType(J.ParameterizedType type, ExecutionContext ctx) {
                J.ParameterizedType pt = (J.ParameterizedType)super.visitParameterizedType(type, (Object)ctx);
                if (TypeUtils.isAssignableTo((String)ConvertToRawType.this.fullyQualifiedTypeName, (JavaType)pt.getType())) {
                    return ((J.Identifier)pt.getClazz()).withPrefix(pt.getPrefix()).withType(pt.getType());
                }
                return pt;
            }
        });
    }

    @ConstructorProperties(value={"fullyQualifiedTypeName"})
    @Generated
    public ConvertToRawType(String fullyQualifiedTypeName) {
        this.fullyQualifiedTypeName = fullyQualifiedTypeName;
    }

    @Generated
    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ConvertToRawType(fullyQualifiedTypeName=" + this.getFullyQualifiedTypeName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvertToRawType)) {
            return false;
        }
        ConvertToRawType other = (ConvertToRawType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        String other$fullyQualifiedTypeName = other.getFullyQualifiedTypeName();
        if (this$fullyQualifiedTypeName == null ? other$fullyQualifiedTypeName != null : !this$fullyQualifiedTypeName.equals(other$fullyQualifiedTypeName)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ConvertToRawType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        result = result * 59 + ($fullyQualifiedTypeName == null ? 43 : $fullyQualifiedTypeName.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

