/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class SimplifyMockitoVerifyWhenGiven
extends Recipe {
    private static final MethodMatcher WHEN_MATCHER = new MethodMatcher("org.mockito.Mockito when(..)");
    private static final MethodMatcher GIVEN_MATCHER = new MethodMatcher("org.mockito.BDDMockito given(..)");
    private static final MethodMatcher VERIFY_MATCHER = new MethodMatcher("org.mockito.Mockito verify(..)");
    private static final MethodMatcher STUBBER_MATCHER = new MethodMatcher("org.mockito.stubbing.Stubber when(..)");
    private static final MethodMatcher EQ_MATCHER = new MethodMatcher("org.mockito.ArgumentMatchers eq(..)");
    private static final MethodMatcher MOCKITO_EQ_MATCHER = new MethodMatcher("org.mockito.Mockito eq(..)");
    final String displayName = "Call to Mockito method \"verify\", \"when\" or \"given\" should be simplified";
    final String description = "Fixes Sonar issue `java:S6068`: Call to Mockito method \"verify\", \"when\" or \"given\" should be simplified.";
    final Set<String> tags = Collections.singleton("RSPEC-6068");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(EQ_MATCHER), new UsesMethod(MOCKITO_EQ_MATCHER)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(methodInvocation, (Object)ctx);
                if ((WHEN_MATCHER.matches((MethodCall)mi) || GIVEN_MATCHER.matches((MethodCall)mi)) && mi.getArguments().get(0) instanceof J.MethodInvocation) {
                    ArrayList<J.MethodInvocation> updatedArguments = new ArrayList<J.MethodInvocation>(mi.getArguments());
                    updatedArguments.set(0, this.checkAndUpdateEq((J.MethodInvocation)mi.getArguments().get(0)));
                    mi = mi.withArguments(updatedArguments);
                } else if (VERIFY_MATCHER.matches(mi.getSelect()) || STUBBER_MATCHER.matches(mi.getSelect())) {
                    mi = this.checkAndUpdateEq(mi);
                }
                this.maybeRemoveImport("org.mockito.ArgumentMatchers.eq");
                this.maybeRemoveImport("org.mockito.Mockito.eq");
                return mi;
            }

            private J.MethodInvocation checkAndUpdateEq(J.MethodInvocation methodInvocation) {
                if (methodInvocation.getArguments().stream().allMatch(arg -> EQ_MATCHER.matches(arg) || MOCKITO_EQ_MATCHER.matches(arg))) {
                    return methodInvocation.withArguments(ListUtils.map((List)methodInvocation.getArguments(), invocation -> (Expression)((Expression)((MethodCall)invocation).getArguments().get(0)).withPrefix(invocation.getPrefix())));
                }
                return methodInvocation;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

