/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class RemoveInitMocksIfRunnersSpecified
extends Recipe {
    final String displayName = "Remove `MockitoAnnotations.initMocks(this)` if specified JUnit runners";
    final String description = "Remove `MockitoAnnotations.initMocks(this)` if specified class-level JUnit runners `@RunWith(MockitoJUnitRunner.class)` or `@ExtendWith(MockitoExtension.class)`.";
    private static final String MOCKITO_EXTENSION = "org.mockito.junit.jupiter.MockitoExtension";
    private static final String MOCKITO_JUNIT_RUNNER = "org.mockito.junit.MockitoJUnitRunner";
    private static final AnnotationMatcher MOCKITO_EXTENSION_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.extension.ExtendWith(org.mockito.junit.jupiter.MockitoExtension.class)");
    private static final AnnotationMatcher MOCKITO_JUNIT_MATCHER = new AnnotationMatcher("@org.junit.runner.RunWith(org.mockito.junit.MockitoJUnitRunner.class)");
    private static final MethodMatcher INIT_MOCKS_MATCHER = new MethodMatcher("org.mockito.MockitoAnnotations initMocks(..)", false);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod(INIT_MOCKS_MATCHER), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType(MOCKITO_EXTENSION, Boolean.valueOf(false)), new UsesType(MOCKITO_JUNIT_RUNNER, Boolean.valueOf(false))})}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (INIT_MOCKS_MATCHER.matches((MethodCall)mi)) {
                    this.maybeRemoveImport("org.mockito.MockitoAnnotations");
                    return null;
                }
                return mi;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                if (md != method && md.getBody() != null && md.getBody().getStatements().isEmpty()) {
                    this.maybeRemoveImport("org.junit.jupiter.api.BeforeEach");
                    this.maybeRemoveImport("org.junit.Before");
                    return null;
                }
                return md;
            }

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cd, ExecutionContext ctx) {
                if (((AnnotationService)this.service(AnnotationService.class)).matches(this.updateCursor((Tree)cd), MOCKITO_EXTENSION_MATCHER) || ((AnnotationService)this.service(AnnotationService.class)).matches(this.updateCursor((Tree)cd), MOCKITO_JUNIT_MATCHER)) {
                    return super.visitClassDeclaration(cd, (Object)ctx);
                }
                return cd;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

