/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class PowerMockitoWhenNewToMockito
extends Recipe {
    private static final MethodMatcher PM_WHEN_NEW = new MethodMatcher("org.powermock.api.mockito.PowerMockito whenNew(..)");
    private static final MethodMatcher WITH_NO_ARGUMENTS = new MethodMatcher("*..* withNoArguments()");
    private static final MethodMatcher WITH_ARGUMENTS = new MethodMatcher("*..* withArguments(..)");
    private static final MethodMatcher WITH_ANY_ARGUMENTS = new MethodMatcher("*..* withAnyArguments()");
    private static final MethodMatcher THEN_RETURN = new MethodMatcher("org.mockito.stubbing.OngoingStubbing thenReturn(..)");
    private static final MethodMatcher MOCKITO_MOCK = new MethodMatcher("org.mockito.Mockito mock(..)");
    private static final MethodMatcher PM_MOCK = new MethodMatcher("org.powermock.api.mockito.PowerMockito mock(..)");
    final String displayName = "Replace `PowerMockito.whenNew` with Mockito counterpart";
    final String description = "Replaces `PowerMockito.whenNew` calls with respective `Mockito.whenConstructed` calls.";

    private static String extractClassName(J.FieldAccess fieldAccess) {
        Expression target = fieldAccess.getTarget();
        if (target instanceof J.FieldAccess) {
            return ((J.FieldAccess)target).getSimpleName();
        }
        if (target instanceof J.Identifier) {
            return ((J.Identifier)target).getSimpleName();
        }
        return fieldAccess.getSimpleName();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(PM_WHEN_NEW), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public @Nullable J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (THEN_RETURN.matches((MethodCall)method) && method.getSelect() instanceof J.MethodInvocation) {
                    boolean withArgumentsMethodMatch;
                    J.MethodInvocation select1 = (J.MethodInvocation)method.getSelect();
                    boolean bl = withArgumentsMethodMatch = WITH_ANY_ARGUMENTS.matches((MethodCall)select1) || WITH_ARGUMENTS.matches((MethodCall)select1) || WITH_NO_ARGUMENTS.matches((MethodCall)select1);
                    if (withArgumentsMethodMatch && select1.getSelect() instanceof J.MethodInvocation) {
                        J.MethodInvocation select2 = (J.MethodInvocation)select1.getSelect();
                        if (PM_WHEN_NEW.matches((MethodCall)select2) && select2.getArguments().size() == 1) {
                            this.maybeRemoveImport("org.powermock.api.mockito.PowerMockito");
                            Cursor containingMethod = this.getCursor().dropParentUntil(x -> x instanceof J.MethodDeclaration);
                            Expression argument = (Expression)select2.getArguments().get(0);
                            if (argument instanceof J.FieldAccess) {
                                ArrayList listOfMocks = (ArrayList)containingMethod.getMessage("POWERMOCKITO_WHEN_NEW_REPLACED", new ArrayList());
                                listOfMocks.add((J.FieldAccess)argument);
                                containingMethod.putMessage("POWERMOCKITO_WHEN_NEW_REPLACED", (Object)listOfMocks);
                                return null;
                            }
                        }
                    }
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }

            public J visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J ret = super.visitMethodDeclaration(method, (Object)ctx);
                List mockArguments = (List)this.getCursor().getMessage("POWERMOCKITO_WHEN_NEW_REPLACED");
                if (mockArguments != null && ret instanceof J.MethodDeclaration) {
                    this.doAfterVisit((TreeVisitor)this.removeMockUsagesVisitor(mockArguments, method));
                    J.MethodDeclaration retM = (J.MethodDeclaration)ret;
                    this.maybeAddImport("org.mockito.MockedConstruction", false);
                    this.maybeAddImport("org.mockito.Mockito", false);
                    for (J.FieldAccess mockArgument : mockArguments) {
                        String mockedClassName = PowerMockitoWhenNewToMockito.extractClassName(mockArgument);
                        String variableNameForMock = VariableNameUtils.generateVariableName((String)("mock" + mockedClassName), (Cursor)this.updateCursor((Tree)ret), (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER);
                        J.MethodDeclaration appliedTemplate = (J.MethodDeclaration)JavaTemplate.builder((String)String.format("try (MockedConstruction<%s> %s = Mockito.mockConstruction(%s.class)) { } ", mockedClassName, variableNameForMock, mockedClassName)).contextSensitive().imports(new String[]{"org.mockito.MockedConstruction"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core"})).build().apply(this.getCursor(), method.getCoordinates().replaceBody(), new Object[0]);
                        J.Try try_ = (J.Try)appliedTemplate.getBody().getStatements().get(0);
                        retM = appliedTemplate.withBody(appliedTemplate.getBody().withStatements(Collections.singletonList(try_.withBody(retM.getBody()))));
                    }
                    return this.autoFormat((J)retM, ctx);
                }
                return ret;
            }

            private JavaIsoVisitor<ExecutionContext> removeMockUsagesVisitor(List<J.FieldAccess> mockArguments, final J.MethodDeclaration inMethod) {
                final Set mockedClassNames = mockArguments.stream().map(x$0 -> PowerMockitoWhenNewToMockito.extractClassName(x$0)).collect(Collectors.toSet());
                return new JavaIsoVisitor<ExecutionContext>(){

                    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                        J.VariableDeclarations ret = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                        if (!inMethod.equals(this.getCursor().firstEnclosing(J.MethodDeclaration.class))) {
                            return ret;
                        }
                        List variables = ListUtils.filter((List)ret.getVariables(), varr -> {
                            J.FieldAccess classReference;
                            J.MethodInvocation initializer;
                            return !(varr.getInitializer() instanceof J.MethodInvocation) || !MOCKITO_MOCK.matches(varr.getInitializer()) && !PM_MOCK.matches(varr.getInitializer()) || (initializer = (J.MethodInvocation)varr.getInitializer()).getArguments().size() != 1 || !(initializer.getArguments().get(0) instanceof J.FieldAccess) || !mockedClassNames.contains(PowerMockitoWhenNewToMockito.extractClassName(classReference = (J.FieldAccess)initializer.getArguments().get(0)));
                        });
                        return variables.isEmpty() ? null : ret.withVariables(variables);
                    }
                };
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

