/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.time.Duration;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class AnyStringToNullable
extends Recipe {
    private static final MethodMatcher ANY_STRING = new MethodMatcher("org.mockito.Mockito anyString()");
    final String displayName = "Replace Mockito 1.x `anyString()` with `nullable(String.class)`";
    final String description = "Since Mockito 2.10 `anyString()` no longer matches null values. Use `nullable(Class)` instead.";
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(1L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ANY_STRING), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (ANY_STRING.matches((MethodCall)mi)) {
                    this.maybeRemoveImport("org.mockito.Mockito.anyString");
                    this.maybeAddImport("org.mockito.ArgumentMatchers", "nullable", false);
                    return (J.MethodInvocation)JavaTemplate.builder((String)"nullable(String.class)").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core-3.12"})).staticImports(new String[]{"org.mockito.ArgumentMatchers.nullable"}).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[0]);
                }
                return mi;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

