/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.Comparator;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.FindTypes;
import org.openrewrite.java.search.IsLikelyTest;
import org.openrewrite.java.tree.J;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.kotlin.KotlinTemplate;
import org.openrewrite.kotlin.tree.K;

public class AddMockitoExtensionIfAnnotationsUsed
extends Recipe {
    final String displayName = "Adds Mockito extensions to Mockito tests";
    final String description = "Adds `@ExtendWith(MockitoExtension.class)` to tests using `@Mock` or `@Captor`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor hasExtendedWithAnnotation = new FindAnnotations("org.junit.jupiter.api.extension.ExtendWith(org.mockito.junit.jupiter.MockitoExtension.class)", Boolean.valueOf(false)).getVisitor();
        TreeVisitor[] hasAnyMockitoAnnotation = new TreeVisitor[]{new FindAnnotations("org.mockito.Captor", Boolean.valueOf(false)).getVisitor(), new FindAnnotations("org.mockito.Mock", Boolean.valueOf(false)).getVisitor(), new FindAnnotations("org.mockito.Spy", Boolean.valueOf(false)).getVisitor(), new FindAnnotations("org.mockito.InjectMocks", Boolean.valueOf(false)).getVisitor()};
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new IsLikelyTest().getVisitor(), new FindTypes("org.junit.jupiter..*", Boolean.valueOf(false)).getVisitor(), Preconditions.not((TreeVisitor)hasExtendedWithAnnotation), Preconditions.or((TreeVisitor[])hasAnyMockitoAnnotation)}), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree preVisit(Tree tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                if (tree instanceof J.CompilationUnit) {
                    return AddMockitoExtensionIfAnnotationsUsed.this.getJavaVisitor().visit(tree, (Object)ctx);
                }
                if (tree instanceof K.CompilationUnit) {
                    return AddMockitoExtensionIfAnnotationsUsed.this.getKotlinVisitor().visit(tree, (Object)ctx);
                }
                return tree;
            }
        });
    }

    private JavaIsoVisitor<ExecutionContext> getJavaVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                this.maybeAddImport("org.mockito.junit.jupiter.MockitoExtension");
                this.maybeAddImport("org.junit.jupiter.api.extension.ExtendWith");
                return (J.ClassDeclaration)JavaTemplate.builder((String)"@ExtendWith(MockitoExtension.class)").imports(new String[]{"org.mockito.junit.jupiter.MockitoExtension"}).imports(new String[]{"org.junit.jupiter.api.extension.ExtendWith"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api", "mockito-junit-jupiter"})).build().apply(this.getCursor(), classDecl.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
            }
        };
    }

    private KotlinIsoVisitor<ExecutionContext> getKotlinVisitor() {
        return new KotlinIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                this.maybeAddImport("org.mockito.junit.jupiter.MockitoExtension");
                this.maybeAddImport("org.junit.jupiter.api.extension.ExtendWith");
                return (J.ClassDeclaration)KotlinTemplate.builder((String)"@ExtendWith(MockitoExtension::class)").imports(new String[]{"org.mockito.junit.jupiter.MockitoExtension"}).imports(new String[]{"org.junit.jupiter.api.extension.ExtendWith"}).parser(KotlinParser.builder().classpathFromResources(ctx, new String[]{"junit-jupiter-api", "mockito-junit-jupiter"})).build().apply(this.getCursor(), classDecl.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

