/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit6;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.AddOrUpdateAnnotationAttribute;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotation;
import org.openrewrite.java.RemoveAnnotationAttribute;
import org.openrewrite.java.trait.Annotated;
import org.openrewrite.java.trait.Literal;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;

public final class MinimumJreConditions
extends Recipe {
    private static final String JRE_IMPORT = "org.junit.jupiter.api.condition.JRE";
    private static final String ENABLED_ON_JRE = "org.junit.jupiter.api.condition.EnabledOnJre";
    private static final String DISABLED_ON_JRE = "org.junit.jupiter.api.condition.DisabledOnJre";
    private static final String ENABLED_FOR_JRE_RANGE = "org.junit.jupiter.api.condition.EnabledForJreRange";
    private static final String DISABLED_FOR_JRE_RANGE = "org.junit.jupiter.api.condition.DisabledForJreRange";
    private static final Annotated.Matcher ENABLED_JRE_MATCHER = new Annotated.Matcher("@org.junit.jupiter.api.condition.EnabledOnJre");
    private static final Annotated.Matcher DISABLED_JRE_MATCHER = new Annotated.Matcher("@org.junit.jupiter.api.condition.DisabledOnJre");
    private static final Annotated.Matcher ENABLED_JRE_RANGE_MATCHER = new Annotated.Matcher("@org.junit.jupiter.api.condition.EnabledForJreRange");
    private static final Annotated.Matcher DISABLED_JRE_RANGE_MATCHER = new Annotated.Matcher("@org.junit.jupiter.api.condition.DisabledForJreRange");
    private static final List<Annotated.Matcher> TEST_ANNOTATION_MATCHERS = Arrays.asList(new Annotated.Matcher("@org.junit.jupiter.api.Test"), new Annotated.Matcher("@org.junit.jupiter.api.TestFactory"), new Annotated.Matcher("@org.junit.jupiter.api.TestTemplate"), new Annotated.Matcher("@org.junit.jupiter.api.RepeatedTest"), new Annotated.Matcher("@org.junit.jupiter.params.ParameterizedTest"));
    @Option(displayName="JRE version", description="The minimum JRE version to use for test conditions.", example="17")
    private final String javaVersion;
    private final String displayName = "Migrate JUnit JRE conditions";
    private final String description = "This recipe will:\n - Remove tests that are only active on JREs that are below the specified version.\n - Adjust ranges to use minimum the specified version.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                J.CompilationUnit c = super.visitCompilationUnit(cu, (Object)ctx);
                if (cu != c) {
                    this.maybeRemoveImport("org.junit.jupiter.api.Test");
                    this.maybeRemoveImport("org.junit.jupiter.api.TestFactory");
                    this.maybeRemoveImport("org.junit.jupiter.api.TestTemplate");
                    this.maybeRemoveImport("org.junit.jupiter.api.RepeatedTest");
                    this.maybeRemoveImport("org.junit.jupiter.params.ParameterizedTest");
                    this.maybeRemoveImport(MinimumJreConditions.ENABLED_ON_JRE);
                    this.maybeRemoveImport(MinimumJreConditions.DISABLED_ON_JRE);
                    this.maybeRemoveImport(MinimumJreConditions.ENABLED_FOR_JRE_RANGE);
                    this.maybeRemoveImport(MinimumJreConditions.DISABLED_FOR_JRE_RANGE);
                }
                return c;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                boolean isUnitTest = false;
                Collection enabledOnJre = null;
                Collection disabledOnJre = null;
                Range enabledOnJreRange = null;
                Range disabledOnJreRange = null;
                Space prefix = Space.EMPTY;
                for (J.Annotation ann : method.getLeadingAnnotations()) {
                    Optional annotated;
                    Cursor annotationCursor = new Cursor(this.getCursor(), (Object)ann);
                    if (TEST_ANNOTATION_MATCHERS.stream().anyMatch(matcher -> matcher.get(annotationCursor).isPresent())) {
                        isUnitTest = true;
                    }
                    if ((annotated = ENABLED_JRE_MATCHER.get(annotationCursor)).isPresent()) {
                        enabledOnJre = annotated.map(a -> MinimumJreConditions.getDefaultAttribute(a).map(this::extractVersionsFromAnnotationArgument).orElseGet(() -> a.getAttribute("versions").map(Literal::getStrings).orElse(null))).orElse(null);
                        prefix = ann.getPrefix();
                    }
                    if ((annotated = DISABLED_JRE_MATCHER.get(annotationCursor)).isPresent()) {
                        disabledOnJre = annotated.map(a -> MinimumJreConditions.getDefaultAttribute(a).map(this::extractVersionsFromAnnotationArgument).orElseGet(() -> a.getAttribute("versions").map(Literal::getStrings).orElse(null))).orElse(null);
                        prefix = ann.getPrefix();
                    }
                    if ((annotated = ENABLED_JRE_RANGE_MATCHER.get(annotationCursor)).isPresent()) {
                        enabledOnJreRange = annotated.map(Range::new).orElse(null);
                        prefix = ann.getPrefix();
                    }
                    if (!(annotated = DISABLED_JRE_RANGE_MATCHER.get(annotationCursor)).isPresent()) continue;
                    disabledOnJreRange = annotated.map(Range::new).orElse(null);
                    prefix = ann.getPrefix();
                }
                if (!isUnitTest || enabledOnJre == null && disabledOnJre == null && enabledOnJreRange == null && disabledOnJreRange == null) {
                    return m;
                }
                if (enabledOnJre != null) {
                    if (enabledOnJre.stream().allMatch(v -> MinimumJreConditions.compareVersions(v, MinimumJreConditions.this.javaVersion) < 0)) {
                        this.maybeRemoveImport(MinimumJreConditions.JRE_IMPORT);
                        return null;
                    }
                    m = this.updateAnnotationVersions(m, (List<String>)enabledOnJre, MinimumJreConditions.ENABLED_ON_JRE, ctx);
                }
                if (disabledOnJre != null) {
                    m = disabledOnJre.stream().allMatch(v -> MinimumJreConditions.compareVersions(v, MinimumJreConditions.this.javaVersion) < 0) ? this.removeAnnotation(m, MinimumJreConditions.DISABLED_ON_JRE, ctx) : this.updateAnnotationVersions(m, (List<String>)disabledOnJre, MinimumJreConditions.DISABLED_ON_JRE, ctx);
                }
                if (enabledOnJreRange != null) {
                    if (MinimumJreConditions.compareVersions(enabledOnJreRange.getMax(), MinimumJreConditions.this.javaVersion) < 0) {
                        this.maybeRemoveImport(MinimumJreConditions.JRE_IMPORT);
                        return null;
                    }
                    m = MinimumJreConditions.compareVersions(enabledOnJreRange.getMin(), MinimumJreConditions.this.javaVersion) <= 0 && enabledOnJreRange.getMaxNotation() == null ? this.removeAnnotation(m, MinimumJreConditions.ENABLED_FOR_JRE_RANGE, ctx) : this.updateRangeStart(m, MinimumJreConditions.ENABLED_FOR_JRE_RANGE, enabledOnJreRange, ctx);
                }
                if (disabledOnJreRange != null) {
                    if (MinimumJreConditions.compareVersions(disabledOnJreRange.getMax(), MinimumJreConditions.this.javaVersion) < 0) {
                        m = this.removeAnnotation(m, MinimumJreConditions.DISABLED_FOR_JRE_RANGE, ctx);
                    } else {
                        if (MinimumJreConditions.compareVersions(disabledOnJreRange.getMin(), MinimumJreConditions.this.javaVersion) <= 0 && disabledOnJreRange.getMaxNotation() == null) {
                            this.maybeRemoveImport(MinimumJreConditions.JRE_IMPORT);
                            return null;
                        }
                        m = this.updateRangeStart(m, MinimumJreConditions.DISABLED_FOR_JRE_RANGE, disabledOnJreRange, ctx);
                    }
                }
                this.replaceSingleVersionRangeWithEquivalentAnnotation(enabledOnJreRange, MinimumJreConditions.ENABLED_FOR_JRE_RANGE, MinimumJreConditions.ENABLED_ON_JRE);
                this.replaceSingleVersionRangeWithEquivalentAnnotation(disabledOnJreRange, MinimumJreConditions.DISABLED_FOR_JRE_RANGE, MinimumJreConditions.DISABLED_ON_JRE);
                if (m != method) {
                    return this.simplifySingleValueAnnotationAttributeArrays(m, prefix);
                }
                return method;
            }

            private J.MethodDeclaration removeAnnotation(J.MethodDeclaration m, String annotationType, ExecutionContext ctx) {
                RemoveAnnotation removeAnnotation = new RemoveAnnotation("@" + annotationType);
                this.maybeRemoveImport(MinimumJreConditions.JRE_IMPORT);
                return removeAnnotation.getVisitor().visitMethodDeclaration(m, ctx);
            }

            private J.MethodDeclaration updateAnnotationVersions(J.MethodDeclaration m, List<String> versions, String annotationType, ExecutionContext ctx) {
                if (versions.stream().anyMatch(v -> MinimumJreConditions.compareVersions(v, MinimumJreConditions.this.javaVersion) < 0)) {
                    AddOrUpdateAnnotationAttribute updatedVersions = new AddOrUpdateAnnotationAttribute(annotationType, "versions", versions.stream().filter(v -> MinimumJreConditions.compareVersions(v, MinimumJreConditions.this.javaVersion) >= 0).collect(Collectors.joining(", ")), null, Boolean.valueOf(false), Boolean.valueOf(false));
                    m = (J.MethodDeclaration)updatedVersions.getVisitor().visitNonNull((Tree)m, (Object)ctx, this.getCursor().getParent());
                }
                return m;
            }

            private J.MethodDeclaration updateRangeStart(J.MethodDeclaration m, String annotationtype, Range range, ExecutionContext ctx) {
                if (MinimumJreConditions.compareVersions(range.getMin(), MinimumJreConditions.this.javaVersion) <= 0 && MinimumJreConditions.compareVersions(range.getMax(), MinimumJreConditions.this.javaVersion) != 0) {
                    String attributeName = range.getMinNotation() == RangeNotation.VERSION ? "minVersion" : "min";
                    RemoveAnnotationAttribute updatedRange = new RemoveAnnotationAttribute(annotationtype, attributeName);
                    m = (J.MethodDeclaration)updatedRange.getVisitor().visitNonNull((Tree)m, (Object)ctx, this.getCursor().getParent());
                }
                return m;
            }

            private void replaceSingleVersionRangeWithEquivalentAnnotation(@Nullable Range range, String rangeAnnotationType, String singleVersionAnnotationType) {
                if (range != null && MinimumJreConditions.compareVersions(range.getMax(), MinimumJreConditions.this.javaVersion) == 0) {
                    this.doAfterVisit(new ChangeType(rangeAnnotationType, singleVersionAnnotationType, Boolean.valueOf(false)).getVisitor());
                    this.doAfterVisit(new RemoveAnnotationAttribute(singleVersionAnnotationType, "min").getVisitor());
                    this.doAfterVisit(new RemoveAnnotationAttribute(singleVersionAnnotationType, "minVersion").getVisitor());
                    this.doAfterVisit(new RemoveAnnotationAttribute(singleVersionAnnotationType, "max").getVisitor());
                    this.doAfterVisit(new RemoveAnnotationAttribute(singleVersionAnnotationType, "maxVersion").getVisitor());
                    String attributeName = range.getNotation() == RangeNotation.VERSION ? "versions" : "value";
                    String newValue = MinimumJreConditions.formatJreValue(MinimumJreConditions.this.javaVersion, range.getNotation());
                    this.doAfterVisit(new AddOrUpdateAnnotationAttribute(singleVersionAnnotationType, attributeName, newValue, null, Boolean.valueOf(false), Boolean.valueOf(false)).getVisitor());
                }
            }

            private J.MethodDeclaration simplifySingleValueAnnotationAttributeArrays(J.MethodDeclaration m, Space prefix) {
                return m.withLeadingAnnotations(ListUtils.map((List)m.getLeadingAnnotations(), ann -> {
                    Cursor parentCursor = this.getCursor().getParent();
                    if (ENABLED_JRE_MATCHER.get((Tree)ann, parentCursor).isPresent() || DISABLED_JRE_MATCHER.get((Tree)ann, parentCursor).isPresent() || ENABLED_JRE_RANGE_MATCHER.get((Tree)ann, parentCursor).isPresent() || DISABLED_JRE_RANGE_MATCHER.get((Tree)ann, parentCursor).isPresent()) {
                        ann = ann.withArguments(ListUtils.map((List)ann.getArguments(), arg -> {
                            List initializer;
                            J.Assignment ass;
                            if (arg instanceof J.Assignment && (ass = (J.Assignment)arg).getAssignment() instanceof J.NewArray && (initializer = ((J.NewArray)ass.getAssignment()).getInitializer()) != null && initializer.size() == 1 && !(initializer.get(0) instanceof J.Empty)) {
                                return ass.withAssignment((Expression)((Expression)initializer.get(0)).withPrefix(ass.getAssignment().getPrefix()));
                            }
                            return arg;
                        })).withPrefix(prefix);
                    }
                    return ann;
                }));
            }

            private List<String> extractVersionsFromAnnotationArgument(Expression expression) {
                if (expression instanceof J.NewArray) {
                    List initializer = ((J.NewArray)expression).getInitializer();
                    if (initializer == null) {
                        return Collections.emptyList();
                    }
                    return initializer.stream().map(Objects::toString).collect(Collectors.toList());
                }
                return Collections.singletonList(expression.toString());
            }
        };
    }

    private static Optional<Expression> getDefaultAttribute(Annotated annotated) {
        if (((J.Annotation)annotated.getTree()).getArguments() == null) {
            return Optional.empty();
        }
        for (Expression argument : ((J.Annotation)annotated.getTree()).getArguments()) {
            if (argument instanceof J.Assignment) continue;
            return Optional.of(argument);
        }
        return MinimumJreConditions.getAttribute(annotated, "value");
    }

    private static Optional<Expression> getAttribute(Annotated annotated, String attribute) {
        if (((J.Annotation)annotated.getTree()).getArguments() == null) {
            return Optional.empty();
        }
        for (Expression argument : ((J.Annotation)annotated.getTree()).getArguments()) {
            J.Assignment assignment;
            if (!(argument instanceof J.Assignment) || !((assignment = (J.Assignment)argument).getVariable() instanceof J.Identifier) || !((J.Identifier)assignment.getVariable()).getSimpleName().equals(attribute)) continue;
            return Optional.of(assignment.getAssignment());
        }
        return Optional.empty();
    }

    private static int compareVersions(String version1, String version2) {
        int v2;
        String numericVersion1 = MinimumJreConditions.fromJREVersion(version1);
        String numericVersion2 = MinimumJreConditions.fromJREVersion(version2);
        int v1 = Integer.parseInt(numericVersion1.replaceAll("\\D", ""));
        int comparison = Integer.compare(v1, v2 = Integer.parseInt(numericVersion2.replaceAll("\\D", "")));
        if (comparison == 0) {
            return comparison;
        }
        return comparison / Math.abs(comparison);
    }

    private static String fromJREVersion(String version) {
        if (version.startsWith("JRE.")) {
            version = version.substring(4);
        }
        if (version.startsWith("JAVA_")) {
            return version.substring(5);
        }
        if ("OTHER".equals(version)) {
            return String.valueOf(Integer.MAX_VALUE);
        }
        return version;
    }

    private static String formatJreValue(String version, @Nullable RangeNotation notation) {
        if (notation == null) {
            return version;
        }
        switch (notation.ordinal()) {
            case 0: {
                return "JRE.JAVA_" + version;
            }
            case 1: {
                return "JAVA_" + version;
            }
        }
        return version;
    }

    @ConstructorProperties(value={"javaVersion"})
    @Generated
    public MinimumJreConditions(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    @Generated
    public String getJavaVersion() {
        return this.javaVersion;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MinimumJreConditions(javaVersion=" + this.getJavaVersion() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinimumJreConditions)) {
            return false;
        }
        MinimumJreConditions other = (MinimumJreConditions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$javaVersion = this.getJavaVersion();
        String other$javaVersion = other.getJavaVersion();
        if (this$javaVersion == null ? other$javaVersion != null : !this$javaVersion.equals(other$javaVersion)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof MinimumJreConditions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $javaVersion = this.getJavaVersion();
        result = result * 59 + ($javaVersion == null ? 43 : $javaVersion.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    static enum RangeNotation {
        JRE,
        STATIC_JRE,
        VERSION;

    }

    private static final class Range {
        private final String min;
        private final @Nullable RangeNotation minNotation;
        private final String max;
        private final @Nullable RangeNotation maxNotation;

        public Range(Annotated annotated) {
            Optional<String> minAttribute = MinimumJreConditions.getAttribute(annotated, "min").map(Objects::toString);
            Optional<String> minVersionAttribute = MinimumJreConditions.getAttribute(annotated, "minVersion").map(Objects::toString);
            Optional<String> maxAttribute = MinimumJreConditions.getAttribute(annotated, "max").map(Objects::toString);
            Optional<String> maxVersionAttribute = MinimumJreConditions.getAttribute(annotated, "maxVersion").map(Objects::toString);
            String min = minAttribute.orElse(minVersionAttribute.orElse(null));
            String max = maxAttribute.orElse(maxVersionAttribute.orElse(null));
            this.min = min == null ? "0" : min;
            this.max = max == null ? String.valueOf(Integer.MAX_VALUE) : max;
            this.minNotation = minAttribute.map(it -> it.startsWith("JRE.") ? RangeNotation.JRE : RangeNotation.STATIC_JRE).orElse(minVersionAttribute.map(__ -> RangeNotation.VERSION).orElse(null));
            this.maxNotation = maxAttribute.map(it -> it.startsWith("JRE.") ? RangeNotation.JRE : RangeNotation.STATIC_JRE).orElse(maxVersionAttribute.map(__ -> RangeNotation.VERSION).orElse(null));
        }

        private RangeNotation getNotation() {
            if (this.minNotation == null && this.maxNotation == null) {
                return RangeNotation.VERSION;
            }
            if (this.maxNotation == null) {
                return this.minNotation;
            }
            return this.maxNotation;
        }

        @Generated
        public String getMin() {
            return this.min;
        }

        @Generated
        public @Nullable RangeNotation getMinNotation() {
            return this.minNotation;
        }

        @Generated
        public String getMax() {
            return this.max;
        }

        @Generated
        public @Nullable RangeNotation getMaxNotation() {
            return this.maxNotation;
        }

        @NonNull
        @Generated
        public String toString() {
            return "MinimumJreConditions.Range(min=" + this.getMin() + ", minNotation=" + (Object)((Object)this.getMinNotation()) + ", max=" + this.getMax() + ", maxNotation=" + (Object)((Object)this.getMaxNotation()) + ")";
        }
    }
}

