/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit6;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class MigrateMethodOrdererAlphanumeric
extends Recipe {
    private static final String METHOD_ORDERER = "org.junit.jupiter.api.MethodOrderer";
    private static final String ALPHANUMERIC = "org.junit.jupiter.api.MethodOrderer.Alphanumeric";
    private static final String METHOD_NAME = "org.junit.jupiter.api.MethodOrderer.MethodName";
    final String displayName = "Migrate `MethodOrderer.Alphanumeric` to `MethodOrderer.MethodName`";
    final String description = "JUnit 6 removed the `MethodOrderer.Alphanumeric` class. This recipe migrates usages to `MethodOrderer.MethodName` which provides similar functionality.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(ALPHANUMERIC, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
                J.FieldAccess fa = super.visitFieldAccess(fieldAccess, (Object)ctx);
                if ("Alphanumeric".equals(fa.getSimpleName()) && fa.getTarget() instanceof J.FieldAccess && TypeUtils.isOfClassType((JavaType)fa.getTarget().getType(), (String)MigrateMethodOrdererAlphanumeric.METHOD_ORDERER)) {
                    this.maybeRemoveImport(MigrateMethodOrdererAlphanumeric.ALPHANUMERIC);
                    this.maybeAddImport(MigrateMethodOrdererAlphanumeric.METHOD_NAME);
                    return fa.withName(fa.getName().withSimpleName("MethodName"));
                }
                return fa;
            }

            public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
                J.Identifier id = super.visitIdentifier(identifier, (Object)ctx);
                if ("Alphanumeric".equals(id.getSimpleName()) && TypeUtils.isOfClassType((JavaType)id.getType(), (String)MigrateMethodOrdererAlphanumeric.ALPHANUMERIC)) {
                    this.maybeRemoveImport(MigrateMethodOrdererAlphanumeric.ALPHANUMERIC);
                    this.maybeAddImport(MigrateMethodOrdererAlphanumeric.METHOD_NAME);
                    return id.withSimpleName("MethodName");
                }
                return id;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

