/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class UseTestMethodOrder
extends Recipe {
    final String displayName = "Migrate from JUnit 4 `@FixedMethodOrder` to JUnit 5 `@TestMethodOrder`";
    final String description = "JUnit optionally allows test method execution order to be specified. This replaces JUnit 4 test execution ordering annotations with JUnit 5 replacements.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.junit.FixMethodOrder", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = classDecl;
                Set methodOrders = FindAnnotations.find((J)cd.withBody(null), (String)"@org.junit.FixMethodOrder");
                if (!methodOrders.isEmpty()) {
                    this.maybeRemoveImport("org.junit.FixMethodOrder");
                    this.maybeRemoveImport("org.junit.runners.MethodSorters");
                    this.maybeAddImport("org.junit.jupiter.api.TestMethodOrder");
                    cd = (J.ClassDeclaration)JavaTemplate.builder((String)"@TestMethodOrder(MethodName.class)").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).imports(new String[]{"org.junit.jupiter.api.TestMethodOrder", "org.junit.jupiter.api.MethodOrderer.*"}).build().apply(this.getCursor(), ((J.Annotation)methodOrders.iterator().next()).getCoordinates().replace(), new Object[0]);
                    this.maybeAddImport("org.junit.jupiter.api.MethodOrderer.MethodName");
                }
                return super.visitClassDeclaration(cd, (Object)ctx);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

