/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class RunnerToExtension
extends Recipe {
    @Option(displayName="Runners", description="The fully qualified class names of the JUnit 4 runners to replace. Sometimes several runners are replaced by a single JUnit Jupiter extension.", example="[ org.springframework.test.context.junit4.SpringRunner ]")
    private final List<String> runners;
    @Option(displayName="Extension", description="The fully qualified class names of the JUnit Jupiter extension.", example="org.springframework.test.context.junit.jupiter.SpringExtension")
    private final String extension;
    private final String displayName = "JUnit 4 `@RunWith` to JUnit Jupiter `@ExtendWith`";
    private final String description = "Replace runners with the JUnit Jupiter extension equivalent.";

    @JsonCreator
    public RunnerToExtension(@JsonProperty(value="runners") List<String> runners, @JsonProperty(value="extension") String extension) {
        this.runners = runners;
        this.extension = extension;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor precondition = Preconditions.or((TreeVisitor[])((TreeVisitor[])this.runners.stream().map(r -> new UsesType(r, Boolean.valueOf(false))).toArray(UsesType[]::new)));
        return Preconditions.check((TreeVisitor)precondition, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final JavaType.Class extensionType;
            private @Nullable JavaTemplate extendsWithTemplate;
            {
                this.extensionType = JavaType.ShallowClass.build((String)RunnerToExtension.this.extension);
            }

            private JavaTemplate getExtendsWithTemplate(ExecutionContext ctx) {
                if (this.extendsWithTemplate == null) {
                    this.extendsWithTemplate = JavaTemplate.builder((String)"@ExtendWith(#{}.class)").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"}).dependsOn(new String[]{"package " + this.extensionType.getPackageName() + ";\nimport org.junit.jupiter.api.extension.Extension;\npublic class " + this.extensionType.getClassName() + " implements Extension {}"})).imports(new String[]{"org.junit.jupiter.api.extension.ExtendWith", "org.junit.jupiter.api.extension.Extension", RunnerToExtension.this.extension}).build();
                }
                return this.extendsWithTemplate;
            }

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                for (String runner : RunnerToExtension.this.runners) {
                    for (J.Annotation runWith : FindAnnotations.find((J)classDecl.withBody(null), (String)("@org.junit.runner.RunWith(" + runner + ".class)"))) {
                        cd = (J.ClassDeclaration)this.getExtendsWithTemplate(ctx).apply(this.updateCursor((Tree)cd), runWith.getCoordinates().replace(), new Object[]{this.extensionType.getClassName()});
                        this.maybeRemoveImport("org.junit.runner.RunWith");
                        this.maybeRemoveImport(runner);
                        this.maybeAddImport("org.junit.jupiter.api.extension.ExtendWith");
                        this.maybeAddImport(RunnerToExtension.this.extension);
                    }
                }
                return cd;
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                for (String runner : RunnerToExtension.this.runners) {
                    for (J.Annotation runWith : FindAnnotations.find((J)method.withBody(null), (String)("@org.junit.runner.RunWith(" + runner + ".class)"))) {
                        md = (J.MethodDeclaration)this.getExtendsWithTemplate(ctx).apply(this.updateCursor((Tree)md), runWith.getCoordinates().replace(), new Object[]{this.extensionType.getClassName()});
                        this.maybeRemoveImport("org.junit.runner.RunWith");
                        this.maybeRemoveImport(runner);
                        this.maybeAddImport("org.junit.jupiter.api.extension.ExtendWith");
                        this.maybeAddImport(RunnerToExtension.this.extension);
                    }
                }
                return md;
            }
        });
    }

    @Generated
    public List<String> getRunners() {
        return this.runners;
    }

    @Generated
    public String getExtension() {
        return this.extension;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RunnerToExtension(runners=" + this.getRunners() + ", extension=" + this.getExtension() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RunnerToExtension)) {
            return false;
        }
        RunnerToExtension other = (RunnerToExtension)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<String> this$runners = this.getRunners();
        List<String> other$runners = other.getRunners();
        if (this$runners == null ? other$runners != null : !((Object)this$runners).equals(other$runners)) {
            return false;
        }
        String this$extension = this.getExtension();
        String other$extension = other.getExtension();
        if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RunnerToExtension;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $runners = this.getRunners();
        result = result * 59 + ($runners == null ? 43 : ((Object)$runners).hashCode());
        String $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

