/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class RemoveDuplicateTestTemplates
extends Recipe {
    private static final AnnotationMatcher TEST_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.Test");
    private static final AnnotationMatcher REPEATED_TEST_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.RepeatedTest");
    final String displayName = "Remove duplicates uses of @TestTemplate implementations for a single method";
    final String description = "Remove duplicates uses of @TestTemplate implementations for a single method.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.junit.jupiter.api.RepeatedTest", Boolean.valueOf(false)), (TreeVisitor)new RemoveDuplicateTestTemplateVisitor());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    private static class RemoveDuplicateTestTemplateVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private RemoveDuplicateTestTemplateVisitor() {
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration md, ExecutionContext ctx) {
            J.MethodDeclaration m = super.visitMethodDeclaration(md, (Object)ctx);
            if (m.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)TEST_ANNOTATION_MATCHER).matches(arg_0))) {
                if (m.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)REPEATED_TEST_ANNOTATION_MATCHER).matches(arg_0))) {
                    this.maybeRemoveImport("org.junit.jupiter.api.Test");
                    return new RemoveAnnotationVisitor(TEST_ANNOTATION_MATCHER).visitMethodDeclaration(m, ctx);
                }
            }
            return m;
        }
    }
}

