/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class LifecycleNonPrivate
extends Recipe {
    private static final List<String> ANNOTATION_TYPES = Arrays.asList("org.junit.jupiter.api.AfterAll", "org.junit.jupiter.api.AfterEach", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.BeforeEach");
    private static final TreeVisitor<?, ExecutionContext> PRECONDITION = Preconditions.or((TreeVisitor[])((TreeVisitor[])ANNOTATION_TYPES.stream().map(r -> new UsesType(r, Boolean.valueOf(false))).toArray(UsesType[]::new)));
    final String displayName = "Make lifecycle methods non private";
    final String description = "Make JUnit 5's `@AfterAll`, `@AfterEach`, `@BeforeAll` and `@BeforeEach` non private.";
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(1L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(PRECONDITION, (TreeVisitor)new LifecycleNonPrivateVisitor());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    static /* synthetic */ List access$100() {
        return ANNOTATION_TYPES;
    }

    private static class LifecycleNonPrivateVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        final List<AnnotationMatcher> lifeCycleAnnotationMatchers = LifecycleNonPrivate.access$100().stream().map(annoFqn -> "@" + annoFqn).map(AnnotationMatcher::new).collect(Collectors.toList());

        private LifecycleNonPrivateVisitor() {
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
            if (J.Modifier.hasModifier((Collection)md.getModifiers(), (J.Modifier.Type)J.Modifier.Type.Private) && md.getLeadingAnnotations().stream().anyMatch(ann -> this.lifeCycleAnnotationMatchers.stream().anyMatch(matcher -> matcher.matches(ann)))) {
                return (J.MethodDeclaration)this.maybeAutoFormat((J)md, (J)md.withModifiers(ListUtils.map((List)md.getModifiers(), modifier -> modifier.getType() == J.Modifier.Type.Private ? null : modifier)), ctx, this.getCursor().getParentOrThrow());
            }
            return md;
        }
    }
}

