/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class HandleExternalResourceRules
extends Recipe {
    private static final AnnotationMatcher ANY_RULE_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.*Rule", Boolean.valueOf(true));
    private static final String CLASS_RULE = "org.junit.ClassRule";
    private static final String EXTERNAL_RESOURCE_RULE = "org.junit.rules.ExternalResource";
    private static final String EXTERNAL_RESOURCE_SUPPORT = "org.junit.jupiter.migrationsupport.rules.ExternalResourceSupport";
    private static final String EXTEND_WITH = "org.junit.jupiter.api.extension.ExtendWith";
    private static final AnnotationMatcher EXTEND_WITH_ANNOTATION_MATCHER = new AnnotationMatcher(String.format("@%s(%s.class)", "org.junit.jupiter.api.extension.ExtendWith", "org.junit.jupiter.migrationsupport.rules.ExternalResourceSupport"), Boolean.valueOf(true));
    private static final String RULE = "org.junit.Rule";
    final String displayName = "Handle the usage of ExternalResourceRule fields using @ExtendWith(ExternalResourceSupport.class)";
    final String description = "Handles the usage of the ExternalResourceRule fields by adding the @ExtendWith(ExternalResourceSupport.class) annotation to the test class.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType(CLASS_RULE, Boolean.valueOf(true)), new UsesType(RULE, Boolean.valueOf(true))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (!((AtomicBoolean)new ExternalResourceRuleScanner().reduce((Tree)cd, new AtomicBoolean(), this.getCursor().getParentOrThrow())).get()) {
                    return cd;
                }
                if (!((AnnotationService)this.service(AnnotationService.class)).matches(this.updateCursor((Tree)cd), EXTEND_WITH_ANNOTATION_MATCHER)) {
                    this.maybeAddImport(HandleExternalResourceRules.EXTERNAL_RESOURCE_SUPPORT);
                    this.maybeAddImport(HandleExternalResourceRules.EXTEND_WITH);
                    return (J.ClassDeclaration)JavaTemplate.builder((String)"@ExtendWith(ExternalResourceSupport.class)").imports(new String[]{HandleExternalResourceRules.EXTERNAL_RESOURCE_SUPPORT, HandleExternalResourceRules.EXTEND_WITH}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-migrationsupport-5", "junit-jupiter-api-5"})).build().apply(this.updateCursor((Tree)cd), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                }
                return cd;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    private static class ExternalResourceRuleScanner
    extends JavaIsoVisitor<AtomicBoolean> {
        private ExternalResourceRuleScanner() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations variableDeclarations, AtomicBoolean hasExternalResourceRule) {
            if (!((AnnotationService)this.service(AnnotationService.class)).matches(this.getCursor(), ANY_RULE_ANNOTATION_MATCHER)) {
                return variableDeclarations;
            }
            return super.visitVariableDeclarations(variableDeclarations, (Object)hasExternalResourceRule);
        }

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, AtomicBoolean hasExternalResourceRule) {
            if (variable.getInitializer() != null && TypeUtils.isAssignableTo((String)HandleExternalResourceRules.EXTERNAL_RESOURCE_RULE, (JavaType)variable.getInitializer().getType())) {
                hasExternalResourceRule.set(true);
            }
            return variable;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDeclaration, AtomicBoolean hasExternalResourceRule) {
            if (((AnnotationService)this.service(AnnotationService.class)).matches(this.getCursor(), ANY_RULE_ANNOTATION_MATCHER) && methodDeclaration.getMethodType() != null && TypeUtils.isAssignableTo((String)HandleExternalResourceRules.EXTERNAL_RESOURCE_RULE, (JavaType)methodDeclaration.getMethodType().getReturnType())) {
                hasExternalResourceRule.set(true);
            }
            return methodDeclaration;
        }
    }
}

