/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.LambdaBlockToExpression;

public class ExpectedExceptionToAssertThrows
extends Recipe {
    final String displayName = "JUnit 4 `ExpectedException` To JUnit Jupiter's `assertThrows()`";
    final String description = "Replace usages of JUnit 4's `@Rule ExpectedException` with JUnit 5's `Assertions.assertThrows()`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.junit.rules.ExpectedException", Boolean.valueOf(false)), (TreeVisitor)new ExpectedExceptionToAssertThrowsVisitor());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    private static class ExpectedExceptionToAssertThrowsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final String FIRST_EXPECTED_EXCEPTION_METHOD_INVOCATION = "firstExpectedExceptionMethodInvocation";
        private static final String STATEMENTS_AFTER_EXPECT_EXCEPTION = "statementsAfterExpectException";
        private static final String HAS_MATCHER = "hasMatcher";
        private static final String EXCEPTION_CLASS = "exceptionClass";
        private static final MethodMatcher EXPECTED_EXCEPTION_ALL_MATCHER = new MethodMatcher("org.junit.rules.ExpectedException expect*(..)");
        private static final MethodMatcher EXPECTED_EXCEPTION_CLASS_MATCHER = new MethodMatcher("org.junit.rules.ExpectedException expect(java.lang.Class)");
        private static final MethodMatcher EXPECTED_MESSAGE_STRING_MATCHER = new MethodMatcher("org.junit.rules.ExpectedException expectMessage(java.lang.String)");
        private static final MethodMatcher EXPECTED_MESSAGE_MATCHER = new MethodMatcher("org.junit.rules.ExpectedException expectMessage(org.hamcrest.Matcher)");
        private static final MethodMatcher EXPECTED_EXCEPTION_MATCHER = new MethodMatcher("org.junit.rules.ExpectedException expect(org.hamcrest.Matcher)");
        private static final MethodMatcher EXPECTED_EXCEPTION_CAUSE_MATCHER = new MethodMatcher("org.junit.rules.ExpectedException expectCause(org.hamcrest.Matcher)");

        private ExpectedExceptionToAssertThrowsVisitor() {
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            cd = cd.withBody(cd.getBody().withStatements(ListUtils.map((List)cd.getBody().getStatements(), statement -> {
                if (statement instanceof J.VariableDeclarations && TypeUtils.isOfClassType((JavaType)((J.VariableDeclarations)statement).getTypeExpression().getType(), (String)"org.junit.rules.ExpectedException")) {
                    this.maybeRemoveImport("org.junit.Rule");
                    this.maybeRemoveImport("org.junit.rules.ExpectedException");
                    return null;
                }
                return statement;
            })));
            this.doAfterVisit(new LambdaBlockToExpression().getVisitor());
            return cd;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            List thrown;
            J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
            if (this.getCursor().pollMessage("hasExpectException") != null && (thrown = m.getThrows()) != null && !thrown.isEmpty()) {
                assert (m.getBody() != null);
                return m.withBody(m.getBody().withPrefix(((NameTree)thrown.get(0)).getPrefix())).withThrows(Collections.emptyList());
            }
            return m;
        }

        public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
            J.Block b = super.visitBlock(block, (Object)ctx);
            List statementsAfterExpectException = (List)this.getCursor().pollMessage(STATEMENTS_AFTER_EXPECT_EXCEPTION);
            if (statementsAfterExpectException == null) {
                return b;
            }
            J.Block statementsAfterExpectExceptionBlock = new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), Collections.emptyList(), Space.format((String)" ")).withStatements(statementsAfterExpectException);
            String exceptionDeclParam = this.getCursor().pollMessage(HAS_MATCHER) != null ? "Throwable exception = " : "";
            Object exceptionClass = this.getCursor().pollMessage(EXCEPTION_CLASS);
            if (exceptionClass == null) {
                exceptionClass = "Exception.class";
            }
            this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertThrows", false);
            Statement firstExpectedExceptionMethodInvocation = (Statement)this.getCursor().getMessage(FIRST_EXPECTED_EXCEPTION_METHOD_INVOCATION);
            String templateString = exceptionClass instanceof String ? "#{}assertThrows(#{}, () -> #{any()});" : "#{}assertThrows(#{any()}, () -> #{any()});";
            b = (J.Block)JavaTemplate.builder((String)templateString).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5", "hamcrest-3"})).staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertThrows"}).build().apply(this.updateCursor((Tree)b), firstExpectedExceptionMethodInvocation.getCoordinates().before(), new Object[]{exceptionDeclParam, exceptionClass, statementsAfterExpectExceptionBlock});
            Cursor updateCursor = this.updateCursor((Tree)b);
            AtomicBoolean removeStatement = new AtomicBoolean(false);
            J.Identifier exceptionIdentifier = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "exception", (JavaType)JavaType.ShallowClass.build((String)"java.lang.Throwable"), null);
            b = b.withStatements(ListUtils.map((List)b.getStatements(), statement -> {
                if (statement instanceof J.MethodInvocation && EXPECTED_EXCEPTION_ALL_MATCHER.matches((MethodCall)((J.MethodInvocation)statement))) {
                    removeStatement.set(true);
                    return this.getExpectExceptionTemplate((J.MethodInvocation)statement, ctx).map(t -> (J.MethodInvocation)t.apply(new Cursor(updateCursor, statement), statement.getCoordinates().replace(), new Object[]{exceptionIdentifier, ((J.MethodInvocation)statement).getArguments().get(0)})).orElse(null);
                }
                return removeStatement.get() ? null : statement;
            }));
            Statement lastStatement = (Statement)b.getStatements().get(b.getStatements().size() - 1);
            if (!this.findSuccessorStatements(new Cursor(this.updateCursor((Tree)b), (Object)lastStatement)).isEmpty()) {
                J.Return returnStatement = new J.Return(Tree.randomId(), ((Statement)b.getStatements().get(b.getStatements().size() - 1)).getPrefix().withComments(Collections.emptyList()), Markers.EMPTY, null);
                return b.withStatements(ListUtils.concat((List)b.getStatements(), (Object)returnStatement));
            }
            return b;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (!EXPECTED_EXCEPTION_ALL_MATCHER.matches((MethodCall)method)) {
                return method;
            }
            this.getCursor().dropParentUntil(J.MethodDeclaration.class::isInstance).putMessage("hasExpectException", (Object)true);
            this.getCursor().dropParentUntil(J.Block.class::isInstance).computeMessageIfAbsent(FIRST_EXPECTED_EXCEPTION_METHOD_INVOCATION, k -> method);
            List<Statement> successorStatements = this.findSuccessorStatements(this.getCursor());
            this.getCursor().putMessageOnFirstEnclosing(J.Block.class, STATEMENTS_AFTER_EXPECT_EXCEPTION, successorStatements);
            if (EXPECTED_EXCEPTION_CLASS_MATCHER.matches((MethodCall)method)) {
                this.getCursor().putMessageOnFirstEnclosing(J.Block.class, EXCEPTION_CLASS, method.getArguments().get(0));
            } else {
                this.getCursor().putMessageOnFirstEnclosing(J.Block.class, HAS_MATCHER, (Object)true);
            }
            return method;
        }

        private List<Statement> findSuccessorStatements(Cursor cursor) {
            if (cursor.firstEnclosing(J.MethodDeclaration.class) == null) {
                return Collections.emptyList();
            }
            ArrayList<Statement> successorStatements = new ArrayList<Statement>();
            Cursor cursorJustBeforeBlock = this.getCursor();
            while (!(cursor.getValue() instanceof J.MethodDeclaration)) {
                if (!(cursor.getValue() instanceof J.Block)) {
                    cursorJustBeforeBlock = cursor;
                    cursor = cursor.getParentTreeCursor();
                    continue;
                }
                J.Block block = (J.Block)cursor.getValue();
                boolean found = false;
                for (Statement statement : block.getStatements()) {
                    if (found) {
                        successorStatements.add(statement);
                        continue;
                    }
                    if (statement != cursorJustBeforeBlock.getValue()) continue;
                    found = true;
                }
                cursor = cursor.getParentTreeCursor();
            }
            return successorStatements;
        }

        private Optional<JavaTemplate> getExpectExceptionTemplate(J.MethodInvocation method, ExecutionContext ctx) {
            String template;
            if (EXPECTED_MESSAGE_STRING_MATCHER.matches((MethodCall)method)) {
                this.maybeAddImport("org.hamcrest.CoreMatchers", "containsString");
                template = "assertThat(#{any(java.lang.Throwable)}.getMessage(), containsString(#{any(java.lang.String)}))";
            } else if (EXPECTED_MESSAGE_MATCHER.matches((MethodCall)method)) {
                template = "assertThat(#{any(java.lang.Throwable)}.getMessage(), #{any(org.hamcrest.Matcher)})";
            } else if (EXPECTED_EXCEPTION_MATCHER.matches((MethodCall)method)) {
                template = "assertThat(#{any(java.lang.Throwable)}, #{any(org.hamcrest.Matcher)})";
            } else if (EXPECTED_EXCEPTION_CAUSE_MATCHER.matches((MethodCall)method)) {
                template = "assertThat(#{any(java.lang.Throwable)}.getCause(), #{any(org.hamcrest.Matcher)})";
            } else {
                return Optional.empty();
            }
            this.maybeAddImport("org.hamcrest.MatcherAssert", "assertThat");
            return Optional.of(JavaTemplate.builder((String)template).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5", "hamcrest-3"})).staticImports(new String[]{"org.hamcrest.MatcherAssert.assertThat", "org.hamcrest.CoreMatchers.containsString"}).build());
        }
    }
}

