/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public class CleanupJUnitImports
extends Recipe {
    final String displayName = "Cleanup JUnit imports";
    final String description = "Removes unused `org.junit` import symbols.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.*", Boolean.valueOf(false)), new UsesType("junit.*", Boolean.valueOf(false))}), (TreeVisitor)new CleanupJUnitImportsVisitor());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    public static class CleanupJUnitImportsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        public J preVisit(J tree, ExecutionContext ctx) {
            this.stopAfterPreVisit();
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile c = (JavaSourceFile)tree;
                for (J.Import imp : c.getImports()) {
                    String packageName = imp.getPackageName();
                    if (!packageName.startsWith("junit") && (!packageName.startsWith("org.junit") || packageName.contains("jupiter"))) continue;
                    this.maybeRemoveImport(imp.getTypeName());
                }
            }
            return tree;
        }
    }
}

