/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.testing.junit5.AssumeNotNullToAssumptions;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class AssumeNotNullToAssumptionsRecipes
extends Recipe {
    public String getDisplayName() {
        return "Transform `Assume` methods to `Assumptions`";
    }

    public String getDescription() {
        return "Transform `Assume` methods without a direct counterpart to equivalent assumptions in `Assumptions`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new SingleArgRecipe(), new VarArgsRecipe()});
    }

    @NullMarked
    public static class SingleArgRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Transform singlar `assumeNotNull(object)` to `assumeFalse(object == null)`";
        }

        public String getDescription() {
            return "Transform singlar `Assume.assumeNotNull(object)` to `Assumptions.assumeFalse(object == null)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.junit.Assume.assumeNotNull(#{object:any(java.lang.Object)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-4"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new AssumeNotNullToAssumptions.SingleArgMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.junit.Assume");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.junit.jupiter.api.Assumptions.assumeFalse(#{object:any(java.lang.Object)} == null);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5", "opentest4j-1"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.Assume", Boolean.valueOf(true)), new UsesMethod("org.junit.Assume assumeNotNull(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class VarArgsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Transform variadic `assumeNotNull(objects...)` to a stream of `assumeFalse(object == null)`";
        }

        public String getDescription() {
            return "Transform `Assume.assumeNotNull(objects...)` to `Stream.of(object1, object2).forEach(o -> Assumptions.assumeFalse(o == null))`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.junit.Assume.assumeNotNull(#{objects:any(java.lang.Object[])});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-4"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.junit.Assume");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.stream.Stream.of(#{objects:any(java.lang.Object[])}).forEach((o)->org.junit.jupiter.api.Assumptions.assumeFalse(o == null));").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5", "opentest4j-1"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.Assume", Boolean.valueOf(true)), new UsesMethod("org.junit.Assume assumeNotNull(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

