/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.stream.Stream;
import org.junit.Assume;
import org.junit.jupiter.api.Assumptions;
import org.openrewrite.java.template.Matcher;
import org.openrewrite.java.template.Matches;
import org.openrewrite.java.template.RecipeDescriptor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

@RecipeDescriptor(name="Transform `Assume` methods to `Assumptions`", description="Transform `Assume` methods without a direct counterpart to equivalent assumptions in `Assumptions`.")
public class AssumeNotNullToAssumptions {

    public static class SingleArgMatcher
    implements Matcher<Expression> {
        public boolean matches(Expression e) {
            return TypeUtils.asArray((JavaType)e.getType()) == null;
        }
    }

    @RecipeDescriptor(name="Transform variadic `assumeNotNull(objects...)` to a stream of `assumeFalse(object == null)`", description="Transform `Assume.assumeNotNull(objects...)` to `Stream.of(object1, object2).forEach(o -> Assumptions.assumeFalse(o == null))`.")
    static class VarArgs {
        VarArgs() {
        }

        void before(Object[] objects) {
            Assume.assumeNotNull((Object[])objects);
        }

        void after(Object[] objects) {
            Stream.of(objects).forEach(o -> Assumptions.assumeFalse((o == null ? 1 : 0) != 0));
        }
    }

    @RecipeDescriptor(name="Transform singlar `assumeNotNull(object)` to `assumeFalse(object == null)`", description="Transform singlar `Assume.assumeNotNull(object)` to `Assumptions.assumeFalse(object == null)`.")
    static class SingleArg {
        SingleArg() {
        }

        void before(@Matches(value=SingleArgMatcher.class) Object object) {
            Assume.assumeNotNull((Object[])new Object[]{object});
        }

        void after(Object object) {
            Assumptions.assumeFalse((object == null ? 1 : 0) != 0);
        }
    }
}

