/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.ChangeMethodTargetToStatic;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public class AssertToAssertions
extends Recipe {
    final String displayName = "JUnit 4 `Assert` To JUnit Jupiter `Assertions`";
    final String description = "Change JUnit 4's `org.junit.Assert` into JUnit Jupiter's `org.junit.jupiter.api.Assertions`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.junit.Assert", Boolean.valueOf(false)), (TreeVisitor)new AssertToAssertionsVisitor());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    public static class AssertToAssertionsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final JavaType ASSERTION_TYPE = JavaType.buildType((String)"org.junit.Assert");

        public @Nullable J preVisit(J tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile c = (JavaSourceFile)tree;
                boolean hasWildcardAssertImport = false;
                for (J.Import imp : c.getImports()) {
                    if (!"org.junit.Assert.*".equals(imp.getQualid().toString())) continue;
                    hasWildcardAssertImport = true;
                    break;
                }
                if (hasWildcardAssertImport) {
                    this.maybeRemoveImport("org.junit.Assert.*");
                    this.maybeAddImport("org.junit.jupiter.api.Assertions", "*", false);
                }
            }
            return tree;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (!AssertToAssertionsVisitor.isJunitAssertMethod(m)) {
                return m;
            }
            this.doAfterVisit(new ChangeMethodTargetToStatic("org.junit.Assert " + m.getSimpleName() + "(..)", "org.junit.jupiter.api.Assertions", null, null, Boolean.valueOf(true)).getVisitor());
            List args = m.getPadding().getArguments().getPadding().getElements();
            Expression firstArg = (Expression)((JRightPadded)args.get(0)).getElement();
            if (args.size() == 2 && ("assertSame".equals(m.getSimpleName()) || "assertNotSame".equals(m.getSimpleName()) || "assertEquals".equals(m.getSimpleName()) || "assertNotEquals".equals(m.getSimpleName()))) {
                return m;
            }
            if (TypeUtils.isString((JavaType)firstArg.getType())) {
                List<JRightPadded> newArgs = new ArrayList(args);
                JRightPadded first = (JRightPadded)newArgs.remove(0);
                List prefixes = args.stream().map(JRightPadded::getElement).map(J::getPrefix).collect(Collectors.toList());
                List afters = args.stream().map(JRightPadded::getAfter).collect(Collectors.toList());
                newArgs = ListUtils.map(newArgs, (i, arg) -> arg.withElement((Object)((Expression)((Expression)arg.getElement()).withPrefix((Space)prefixes.get((int)i)))).withAfter(Space.EMPTY));
                if (!((Space)afters.get(afters.size() - 1)).getComments().isEmpty()) {
                    newArgs.add(first.withElement((Object)((Expression)((Expression)first.getElement()).withPrefix(((Space)afters.get(afters.size() - 1)).withComments(ListUtils.mapLast((List)((Space)afters.get(afters.size() - 1)).getComments(), c -> c.withSuffix(((Expression)first.getElement()).getPrefix().getWhitespace())))))).withAfter(first.getAfter().withWhitespace(((Comment)((Space)afters.get(afters.size() - 1)).getComments().get(((Space)afters.get(afters.size() - 1)).getComments().size() - 1)).getSuffix())));
                } else {
                    newArgs.add(first.withElement((Object)((Expression)((Expression)first.getElement()).withPrefix((Space)prefixes.get(prefixes.size() - 1)))).withAfter(first.getAfter().withWhitespace(((Space)afters.get(afters.size() - 1)).getWhitespace())));
                }
                m = m.getPadding().withArguments(m.getPadding().getArguments().getPadding().withElements(newArgs));
            }
            return m;
        }

        private static boolean isJunitAssertMethod(J.MethodInvocation method) {
            if (method.getMethodType() != null && TypeUtils.isOfType((JavaType)ASSERTION_TYPE, (JavaType)method.getMethodType().getDeclaringType())) {
                return !"assertThat".equals(method.getSimpleName());
            }
            if (!(method.getSelect() instanceof J.Identifier)) {
                return false;
            }
            J.Identifier receiver = (J.Identifier)method.getSelect();
            if (!(receiver.getType() instanceof JavaType.FullyQualified)) {
                return false;
            }
            JavaType.FullyQualified receiverType = (JavaType.FullyQualified)receiver.getType();
            return "org.junit.Assert".equals(receiverType.getFullyQualifiedName());
        }
    }
}

