/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class AddMissingTestBeforeAfterAnnotations
extends Recipe {
    private final String displayName = "Add missing `@BeforeEach`, `@AfterEach`, `@Test` to overriding methods";
    private final String description = "Adds `@BeforeEach`, `@AfterEach`, `@Test` to methods overriding superclass methods if the annotations are present on the superclass method.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (classDecl.getExtends() != null) {
                    return (J.ClassDeclaration)SearchResult.found((Tree)classDecl);
                }
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }
        }, (TreeVisitor)new AddMissingTestBeforeAfterAnnotationsVisitor());
    }

    @Generated
    public AddMissingTestBeforeAfterAnnotations() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddMissingTestBeforeAfterAnnotations(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddMissingTestBeforeAfterAnnotations)) {
            return false;
        }
        AddMissingTestBeforeAfterAnnotations other = (AddMissingTestBeforeAfterAnnotations)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddMissingTestBeforeAfterAnnotations;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private static class AddMissingTestBeforeAfterAnnotationsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private AddMissingTestBeforeAfterAnnotationsVisitor() {
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            if (!method.hasModifier(J.Modifier.Type.Static) && !method.isConstructor()) {
                JavaType.Method currMethod = method.getMethodType();
                Optional superMethod = TypeUtils.findOverriddenMethod((JavaType.Method)currMethod);
                while (superMethod.isPresent()) {
                    method = this.maybeAddMissingAnnotation(method, (JavaType.Method)superMethod.get(), LifecyleAnnotation.BEFORE_EACH, ctx);
                    method = this.maybeAddMissingAnnotation(method, (JavaType.Method)superMethod.get(), LifecyleAnnotation.AFTER_EACH, ctx);
                    method = this.maybeAddMissingAnnotation(method, (JavaType.Method)superMethod.get(), LifecyleAnnotation.TEST, ctx);
                    currMethod = (JavaType.Method)superMethod.get();
                    superMethod = TypeUtils.findOverriddenMethod((JavaType.Method)currMethod);
                }
            }
            return super.visitMethodDeclaration(method, (Object)ctx);
        }

        private J.MethodDeclaration maybeAddMissingAnnotation(J.MethodDeclaration method, JavaType.Method superMethod, LifecyleAnnotation la, ExecutionContext ctx) {
            if (la.needsAnnotation(method, superMethod)) {
                this.maybeAddImport(la.newAnnotation);
                return (J.MethodDeclaration)JavaTemplate.builder((String)la.newAnnotationSimple).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).imports(new String[]{la.newAnnotation}).build().apply(this.getCursor(), method.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
            }
            return method;
        }
    }

    static enum LifecyleAnnotation {
        BEFORE_EACH("org.junit.Before", "org.junit.jupiter.api.BeforeEach"),
        AFTER_EACH("org.junit.After", "org.junit.jupiter.api.AfterEach"),
        TEST("org.junit.Test", "org.junit.jupiter.api.Test");

        String newAnnotation;
        String newAnnotationSimple;
        private AnnotationMatcher newAnnotationMatcher;
        private Predicate<JavaType.FullyQualified> newAnnotationPredicate;
        private Predicate<JavaType.FullyQualified> oldAnnotationPredicate;

        private LifecyleAnnotation(String oldAnnotation, String newAnnotation) {
            this.newAnnotation = newAnnotation;
            this.newAnnotationSimple = "@" + newAnnotation.substring(newAnnotation.lastIndexOf(".") + 1);
            this.newAnnotationMatcher = new AnnotationMatcher("@" + newAnnotation);
            this.newAnnotationPredicate = n -> TypeUtils.isOfClassType((JavaType)n, (String)newAnnotation);
            this.oldAnnotationPredicate = n -> TypeUtils.isOfClassType((JavaType)n, (String)oldAnnotation);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean needsAnnotation(J.MethodDeclaration method, JavaType.Method superMethod) {
            boolean superMethodHasAnnotation = superMethod.getAnnotations().stream().anyMatch(this.oldAnnotationPredicate.or(this.newAnnotationPredicate));
            if (!superMethodHasAnnotation) return false;
            if (method.getAllAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)this.newAnnotationMatcher).matches(arg_0))) return false;
            return true;
        }
    }
}

