/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.jmockit;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.testing.jmockit.JMockitUtils;
import org.openrewrite.java.tree.J;

public class JMockitAnnotatedArgumentToMockito
extends Recipe {
    final String displayName = "Convert JMockit `@Mocked` and `@Injectable` annotated arguments";
    final String description = "Convert JMockit `@Mocked` and `@Injectable` annotated arguments into Mockito statements.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("mockit.Mocked", Boolean.valueOf(false)), new UsesType("mockit.Injectable", Boolean.valueOf(false))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDeclaration, ExecutionContext ctx) {
                J.MethodDeclaration md = super.visitMethodDeclaration(methodDeclaration, (Object)ctx);
                List parameters = md.getParameters();
                if (!parameters.isEmpty() && !(parameters.get(0) instanceof J.Empty)) {
                    this.maybeRemoveImport("mockit.Injectable");
                    this.maybeRemoveImport("mockit.Mocked");
                    this.maybeAddImport("org.mockito.Mockito");
                    ArrayList mockedParameter = new ArrayList();
                    md = md.withParameters(ListUtils.map((List)parameters, parameter -> {
                        J.VariableDeclarations variableDeclarations;
                        if (!(!(parameter instanceof J.VariableDeclarations) || FindAnnotations.find((J)(variableDeclarations = (J.VariableDeclarations)parameter), (String)"mockit.Injectable").isEmpty() && FindAnnotations.find((J)variableDeclarations, (String)"mockit.Mocked").isEmpty())) {
                            mockedParameter.add(variableDeclarations);
                            return null;
                        }
                        return parameter;
                    }));
                    if (!mockedParameter.isEmpty()) {
                        JavaTemplate addStatementsTemplate = JavaTemplate.builder((String)"#{} #{} = Mockito.mock(#{}.class);\n").javaParser(JMockitUtils.getJavaParser(ctx)).imports(new String[]{"org.mockito.Mockito"}).contextSensitive().build();
                        for (int i = mockedParameter.size() - 1; i >= 0; --i) {
                            J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)mockedParameter.get(i);
                            md = (J.MethodDeclaration)addStatementsTemplate.apply(this.updateCursor((Tree)md), md.getBody().getCoordinates().firstStatement(), new Object[]{variableDeclarations.getTypeExpression().toString(), ((J.VariableDeclarations.NamedVariable)variableDeclarations.getVariables().get(0)).getSimpleName(), variableDeclarations.getTypeExpression().toString()});
                        }
                    }
                }
                return md;
            }
        });
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JMockitAnnotatedArgumentToMockito)) {
            return false;
        }
        JMockitAnnotatedArgumentToMockito other = (JMockitAnnotatedArgumentToMockito)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof JMockitAnnotatedArgumentToMockito;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

