/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.hamcrest;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class RemoveIsMatcher
extends Recipe {
    final String displayName = "Remove Hamcrest `is(Matcher)`";
    final String description = "Remove Hamcrest `is(Matcher)` ahead of migration.";
    static final MethodMatcher IS_MATCHER = new MethodMatcher("org.hamcrest.*Matchers is(org.hamcrest.Matcher)");
    static final MethodMatcher ASSERT_THAT_MATCHER = new MethodMatcher("org.hamcrest.MatcherAssert assertThat(..)");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ASSERT_THAT_MATCHER), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation mi, ExecutionContext ctx) {
                if (ASSERT_THAT_MATCHER.matches((MethodCall)mi)) {
                    this.getCursor().putMessage("ASSERT_THAT", (Object)mi);
                } else if (IS_MATCHER.matches((MethodCall)mi) && this.getCursor().pollNearestMessage("ASSERT_THAT") != null) {
                    this.maybeRemoveImport("org.hamcrest.Matchers.is");
                    this.maybeRemoveImport("org.hamcrest.CoreMatchers.is");
                    return ((Expression)mi.getArguments().get(0)).withPrefix(mi.getPrefix());
                }
                return super.visitMethodInvocation(mi, (Object)ctx);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

