/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.easymock;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveExtendsEasyMockSupport
extends Recipe {
    private static final String EASYMOCK = "org.easymock.EasyMockSupport";
    final String displayName = "Migrate Test classes that extend `org.easymock.EasyMockSupport` to use Mockito";
    final String description = "Modify test classes by removing extends EasyMockSupport and replacing EasyMock methods with Mockito equivalents.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(EASYMOCK, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (cd.getExtends() != null && TypeUtils.isAssignableTo((String)RemoveExtendsEasyMockSupport.EASYMOCK, (JavaType)cd.getExtends().getType())) {
                    this.maybeRemoveImport(RemoveExtendsEasyMockSupport.EASYMOCK);
                    cd = cd.withExtends(null);
                }
                return cd;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

