/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public final class TestsShouldIncludeAssertions
extends Recipe {
    private static final List<String> TEST_ANNOTATIONS = Collections.singletonList("org.junit.jupiter.api.Test");
    private static final List<String> DEFAULT_ASSERTIONS = Arrays.asList("com.github.tomakehurst.wiremock.client.WireMock", "io.restassured", "mockit", "org.assertj.core.api", "org.easymock", "org.hamcrest.MatcherAssert", "org.jmock", "org.junit.Assert", "org.junit.jupiter.api.Assertions", "org.mockito.Mockito.verify", "org.mockito.Mockito.verifyNoInteractions", "org.mockito.Mockito.verifyNoMoreInteractions", "org.mockito.Mockito.verifyZeroInteractions", "org.springframework.test.web.client.MockRestServiceServer.verify", "org.springframework.test.web.servlet.ResultActions", "reactor.test.StepVerifier");
    @Option(displayName="Additional assertions", description="A comma delimited list of packages and/or classes that will be identified as assertions. I.E. a common assertion utility `org.foo.TestUtil`.", example="org.foo.TestUtil, org.bar", required=false)
    private final @Nullable String additionalAsserts;
    private final String displayName = "Include an assertion in tests";
    private final String description = "For tests not having any assertions, wrap the statements with JUnit Jupiter's `Assertions#assertDoesNotThrow(..)`.";
    private final Set<String> tags = Collections.singleton("RSPEC-S2699");

    public Validated<Object> validate() {
        Validated validated = super.validate().and(Validated.required((String)"assertions", DEFAULT_ASSERTIONS));
        if (validated.isValid()) {
            validated = validated.and(Validated.test((String)"assertions", (String)"Assertions must not be empty and at least contain org.junit.jupiter.api.Assertions", DEFAULT_ASSERTIONS, a -> a.stream().filter("org.junit.jupiter.api.Assertions"::equals).findAny().isPresent()));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.jupiter.api.Test", Boolean.valueOf(false)), Preconditions.not((TreeVisitor)new KotlinFileChecker())}), (TreeVisitor)new TestShouldIncludeAssertionsVisitor(this.additionalAsserts));
    }

    @ConstructorProperties(value={"additionalAsserts"})
    @Generated
    public TestsShouldIncludeAssertions(@Nullable String additionalAsserts) {
        this.additionalAsserts = additionalAsserts;
    }

    @Generated
    public @Nullable String getAdditionalAsserts() {
        return this.additionalAsserts;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @NonNull
    @Generated
    public String toString() {
        return "TestsShouldIncludeAssertions(additionalAsserts=" + this.getAdditionalAsserts() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestsShouldIncludeAssertions)) {
            return false;
        }
        TestsShouldIncludeAssertions other = (TestsShouldIncludeAssertions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$additionalAsserts = this.getAdditionalAsserts();
        String other$additionalAsserts = other.getAdditionalAsserts();
        if (this$additionalAsserts == null ? other$additionalAsserts != null : !this$additionalAsserts.equals(other$additionalAsserts)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof TestsShouldIncludeAssertions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $additionalAsserts = this.getAdditionalAsserts();
        result = result * 59 + ($additionalAsserts == null ? 43 : $additionalAsserts.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    private static class TestShouldIncludeAssertionsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final Map<String, Set<J.Block>> matcherPatternToClassInvocation = new HashMap<String, Set<J.Block>>();
        private final List<String> additionalAsserts;

        TestShouldIncludeAssertionsVisitor(@Nullable String additionalAsserts) {
            ArrayList<String> assertions = new ArrayList<String>();
            if (additionalAsserts != null) {
                assertions.addAll(Arrays.asList(additionalAsserts.split(",\\s*")));
            }
            this.additionalAsserts = assertions;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            if (!this.methodIsTest(method) || method.getBody() == null || method.getBody().getStatements().isEmpty() || this.methodIsDisabled(method) || this.methodHasAssertion(method.getBody()) || this.methodInvocationInBodyContainsAssertion()) {
                return method;
            }
            J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
            J.Block body = md.getBody();
            if (body != null) {
                this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertDoesNotThrow");
                md = (J.MethodDeclaration)JavaTemplate.builder((String)"assertDoesNotThrow(() -> #{any()});").staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertDoesNotThrow"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build().apply(this.updateCursor((Tree)md), md.getCoordinates().replaceBody(), new Object[]{body});
            }
            return md;
        }

        private boolean methodIsTest(J.MethodDeclaration methodDeclaration) {
            for (J.Annotation leadingAnnotation : methodDeclaration.getLeadingAnnotations()) {
                for (String testAnnotation : TEST_ANNOTATIONS) {
                    if (!TypeUtils.isOfClassType((JavaType)leadingAnnotation.getType(), (String)testAnnotation)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean methodIsDisabled(J.MethodDeclaration methodDeclaration) {
            for (J.Annotation leadingAnnotation : methodDeclaration.getLeadingAnnotations()) {
                if (!TypeUtils.isOfClassType((JavaType)leadingAnnotation.getType(), (String)"org.junit.jupiter.api.Disabled")) continue;
                return true;
            }
            return false;
        }

        private boolean methodHasAssertion(J.Block body) {
            AtomicBoolean hasAssertion = new AtomicBoolean(Boolean.FALSE);
            JavaIsoVisitor<AtomicBoolean> findAssertionVisitor = new JavaIsoVisitor<AtomicBoolean>(){

                public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicBoolean atomicBoolean) {
                    J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)atomicBoolean);
                    if (this.isAssertion(mi)) {
                        atomicBoolean.set(Boolean.TRUE);
                    }
                    return mi;
                }
            };
            findAssertionVisitor.visit((Tree)body, (Object)hasAssertion);
            return hasAssertion.get();
        }

        private boolean methodInvocationInBodyContainsAssertion() {
            final J.ClassDeclaration classDeclaration = (J.ClassDeclaration)this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).getValue();
            JavaIsoVisitor<Set<MethodMatcher>> findMethodDeclarationsVisitor = new JavaIsoVisitor<Set<MethodMatcher>>(){

                public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Set<MethodMatcher> methodMatchers) {
                    J.MethodInvocation mi = super.visitMethodInvocation(method, methodMatchers);
                    if (classDeclaration.getType() != null && mi.getMethodType() != null) {
                        JavaType.Method mType = mi.getMethodType();
                        if (classDeclaration.getType().getFullyQualifiedName().equals(mType.getDeclaringType().getFullyQualifiedName())) {
                            methodMatchers.add(new MethodMatcher(mType));
                        }
                    }
                    return mi;
                }
            };
            HashSet methodMatchers = new HashSet();
            findMethodDeclarationsVisitor.visit((Tree)classDeclaration, methodMatchers);
            HashSet methodBodies = new HashSet();
            methodMatchers.forEach(matcher -> {
                Set declarationBodies = this.matcherPatternToClassInvocation.computeIfAbsent(matcher.toString(), k -> this.findMethodDeclarations(classDeclaration, (MethodMatcher)matcher));
                methodBodies.addAll(declarationBodies);
            });
            return methodBodies.stream().anyMatch(this::methodHasAssertion);
        }

        private Set<J.Block> findMethodDeclarations(final J.ClassDeclaration classDeclaration, final MethodMatcher methodMatcher) {
            JavaIsoVisitor<Set<J.Block>> findMethodDeclarationVisitor = new JavaIsoVisitor<Set<J.Block>>(){

                public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, Set<J.Block> blocks) {
                    J.MethodDeclaration m = super.visitMethodDeclaration(method, blocks);
                    if (methodMatcher.matches(m, classDeclaration) && m.getBody() != null) {
                        blocks.add(m.getBody());
                    }
                    return m;
                }
            };
            HashSet<J.Block> blocks = new HashSet<J.Block>();
            findMethodDeclarationVisitor.visit((Tree)classDeclaration, blocks);
            return blocks;
        }

        private boolean isAssertion(J.MethodInvocation methodInvocation) {
            if (methodInvocation.getMethodType() == null) {
                return false;
            }
            String fqt = methodInvocation.getMethodType().getDeclaringType().getFullyQualifiedName();
            for (String assertionClassOrPackage : DEFAULT_ASSERTIONS) {
                if (!fqt.startsWith(assertionClassOrPackage)) continue;
                return true;
            }
            String methodFqn = methodInvocation.getMethodType().getDeclaringType().getFullyQualifiedName() + "." + methodInvocation.getSimpleName();
            for (String assertMethod : DEFAULT_ASSERTIONS) {
                if (!assertMethod.equals(methodFqn)) continue;
                return true;
            }
            if (this.additionalAsserts != null) {
                for (String assertionClassOrPackage : this.additionalAsserts) {
                    if (!fqt.startsWith(assertionClassOrPackage)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

