/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.FindEmptyMethods;
import org.openrewrite.java.tree.J;

public class RemoveEmptyTests
extends Recipe {
    final String displayName = "Remove empty tests without comments";
    final String description = "Removes empty methods with a `@Test` annotation if the body does not have comments.";
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);
    final Set<String> tags = Collections.singleton("RSPEC-S1186");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindEmptyMethods(Boolean.valueOf(false)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public @Nullable J visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                if (this.hasTestAnnotation(method) && this.isEmptyMethod(method)) {
                    return null;
                }
                return super.visitMethodDeclaration(method, (Object)ctx);
            }

            private boolean hasTestAnnotation(J.MethodDeclaration method) {
                return method.getLeadingAnnotations().stream().filter(o -> o.getAnnotationType() instanceof J.Identifier).anyMatch(o -> "Test".equals(o.getSimpleName()));
            }

            private boolean isEmptyMethod(J.MethodDeclaration method) {
                return !method.isConstructor() && (method.getBody() == null || method.getBody().getStatements().isEmpty() && method.getBody().getEnd().getComments().isEmpty());
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

