/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.util.Collections;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.KotlinVisitor;
import org.openrewrite.kotlin.marker.KObject;
import org.openrewrite.kotlin.marker.SingleExpressionBlock;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Markers;

public class KotlinTestMethodsShouldReturnUnit
extends Recipe {
    private static final String TEST_ANNOTATION_PATTERN = "org..* *Test*";
    private static final JavaType.Class KOTLIN_UNIT = (JavaType.Class)JavaType.buildType((String)"kotlin.Unit");
    final String displayName = "Kotlin test methods should have return type `Unit`";
    final String description = "Kotlin test methods annotated with `@Test`, `@ParameterizedTest`, `@RepeatedTest`, `@TestTemplate` should have `Unit` return type. Other return types can cause test discovery issues, and warnings as of JUnit 5.13+. This recipe changes the return type to `Unit` and removes `return` statements.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(TEST_ANNOTATION_PATTERN, Boolean.valueOf(true)), (TreeVisitor)new KotlinIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                JavaType.Method methodType = m.getMethodType();
                if (m.getBody() == null || methodType == null || TypeUtils.isOfType((JavaType)methodType.getReturnType(), (JavaType)KOTLIN_UNIT)) {
                    return m;
                }
                if (!((AnnotationService)this.service(AnnotationService.class)).matches(this.getCursor(), new AnnotationMatcher(KotlinTestMethodsShouldReturnUnit.TEST_ANNOTATION_PATTERN, Boolean.valueOf(true)))) {
                    return m;
                }
                JavaType.Method newMethodType = methodType.withReturnType((JavaType)KOTLIN_UNIT);
                if ((m = m.withMethodType(newMethodType).withName(m.getName().withType((JavaType)newMethodType))).getBody().getMarkers().findFirst(SingleExpressionBlock.class).isPresent()) {
                    return m.withReturnTypeExpression((TypeTree)new J.Identifier(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, Collections.emptyList(), KOTLIN_UNIT.getClassName(), (JavaType)KOTLIN_UNIT, null));
                }
                return m.withReturnTypeExpression(null).withBody((J.Block)new RemoveDirectReturns().visit((Tree)m.getBody(), ctx));
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    private static class RemoveDirectReturns
    extends KotlinVisitor<ExecutionContext> {
        private RemoveDirectReturns() {
        }

        public J visitClassDeclaration(J.ClassDeclaration classDeclaration, ExecutionContext ctx) {
            return classDeclaration.getMarkers().findFirst(KObject.class).isPresent() ? classDeclaration : super.visitClassDeclaration(classDeclaration, (Object)ctx);
        }

        public J.Lambda visitLambda(J.Lambda lambda, ExecutionContext ctx) {
            return lambda;
        }

        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            return newClass;
        }

        public @Nullable J visitReturn(K.Return retrn, ExecutionContext ctx) {
            Expression returnExpr = retrn.getExpression().getExpression();
            return returnExpr instanceof Statement ? returnExpr.withPrefix(retrn.getPrefix()) : null;
        }
    }
}

