/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class AssertTrueNullToAssertNull
extends Recipe {
    private static final MethodMatcher ASSERT_TRUE = new MethodMatcher("org.junit.jupiter.api.Assertions assertTrue(..)");
    final String displayName = "Replace JUnit `assertTrue(a == null)` to `assertNull(a)`";
    final String description = "Using `assertNull(a)` is simpler and more clear.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ASSERT_TRUE), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (ASSERT_TRUE.matches((MethodCall)mi) && this.isEqualBinaryWithNull(mi)) {
                    Object[] args;
                    J.Binary binary = (J.Binary)mi.getArguments().get(0);
                    Expression nonNullExpression = this.getNonNullExpression(binary);
                    StringBuilder sb = new StringBuilder();
                    if (mi.getSelect() == null) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertNull");
                    } else {
                        sb.append("Assertions.");
                    }
                    sb.append("assertNull(#{any(java.lang.Object)}");
                    if (mi.getArguments().size() == 2) {
                        sb.append(", #{any()}");
                        args = new J[]{nonNullExpression, (J)mi.getArguments().get(1)};
                    } else {
                        args = new J[]{nonNullExpression};
                    }
                    sb.append(")");
                    JavaTemplate t = mi.getSelect() == null ? JavaTemplate.builder((String)sb.toString()).contextSensitive().staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertNull"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build() : JavaTemplate.builder((String)sb.toString()).contextSensitive().imports(new String[]{"org.junit.jupiter.api.Assertions"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build();
                    return t.apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), args);
                }
                return mi;
            }

            private Expression getNonNullExpression(J.Binary binary) {
                if (binary.getRight() instanceof J.Literal) {
                    boolean isNull;
                    boolean bl = isNull = ((J.Literal)binary.getRight()).getValue() == null;
                    if (isNull) {
                        return binary.getLeft();
                    }
                }
                return binary.getRight();
            }

            private boolean isEqualBinaryWithNull(J.MethodInvocation method) {
                if (method.getArguments().isEmpty()) {
                    return false;
                }
                Expression firstArgument = (Expression)method.getArguments().get(0);
                if (!(firstArgument instanceof J.Binary)) {
                    return false;
                }
                J.Binary binary = (J.Binary)firstArgument;
                if (binary.getOperator() != J.Binary.Type.Equal) {
                    return false;
                }
                return J.Literal.isLiteralValue((Expression)binary.getLeft(), null) || J.Literal.isLiteralValue((Expression)binary.getRight(), null);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

