/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class AssertTrueEqualsToAssertEquals
extends Recipe {
    private static final MethodMatcher ASSERT_TRUE = new MethodMatcher("org.junit.jupiter.api.Assertions assertTrue(..)");
    final String displayName = "Replace JUnit `assertTrue(a.equals(b))` to `assertEquals(a,b)`";
    final String description = "Using `assertEquals(a,b)` is simpler and more clear.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ASSERT_TRUE), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            JavaParser.Builder<?, ?> javaParser = null;

            private JavaParser.Builder<?, ?> javaParser(ExecutionContext ctx) {
                if (this.javaParser == null) {
                    this.javaParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"});
                }
                return this.javaParser;
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (ASSERT_TRUE.matches((MethodCall)mi) && this.isEquals((Expression)mi.getArguments().get(0))) {
                    Object[] args;
                    StringBuilder sb = new StringBuilder();
                    if (mi.getSelect() == null) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertEquals");
                    } else {
                        sb.append("Assertions.");
                    }
                    J.MethodInvocation s = (J.MethodInvocation)mi.getArguments().get(0);
                    sb.append("assertEquals(#{any(java.lang.Object)},#{any(java.lang.Object)}");
                    if (mi.getArguments().size() == 2) {
                        args = new Object[]{s.getSelect(), s.getArguments().get(0), mi.getArguments().get(1)};
                        sb.append(", #{any()}");
                    } else {
                        args = new Object[]{s.getSelect(), s.getArguments().get(0)};
                    }
                    sb.append(")");
                    JavaTemplate t = mi.getSelect() == null ? JavaTemplate.builder((String)sb.toString()).contextSensitive().staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertEquals"}).javaParser(this.javaParser(ctx)).build() : JavaTemplate.builder((String)sb.toString()).contextSensitive().imports(new String[]{"org.junit.jupiter.api.Assertions.assertEquals"}).javaParser(this.javaParser(ctx)).build();
                    return t.apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), args);
                }
                return mi;
            }

            private boolean isEquals(Expression expr) {
                if (!(expr instanceof J.MethodInvocation)) {
                    return false;
                }
                J.MethodInvocation methodInvocation = (J.MethodInvocation)expr;
                return "equals".equals(methodInvocation.getName().getSimpleName()) && methodInvocation.getArguments().size() == 1;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

