/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class AssertTrueComparisonToAssertEquals
extends Recipe {
    private static final MethodMatcher ASSERT_TRUE = new MethodMatcher("org.junit.jupiter.api.Assertions assertTrue(..)");
    final String displayName = "Junit `assertTrue(a == b)` to `assertEquals(a,b)`";
    final String description = "Using `assertEquals(a,b)` is simpler and more clear.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ASSERT_TRUE), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            JavaParser.Builder<?, ?> javaParser = null;

            private JavaParser.Builder<?, ?> javaParser(ExecutionContext ctx) {
                if (this.javaParser == null) {
                    this.javaParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"});
                }
                return this.javaParser;
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (ASSERT_TRUE.matches((MethodCall)mi) && this.isEqualBinary(mi)) {
                    JavaTemplate t;
                    Object[] args;
                    J.Binary binary = (J.Binary)mi.getArguments().get(0);
                    StringBuilder sb = new StringBuilder();
                    if (mi.getSelect() != null) {
                        sb.append("Assertions.");
                    }
                    sb.append("assertEquals(#{any(java.lang.Object)}, #{any(java.lang.Object)}");
                    if (mi.getArguments().size() == 2) {
                        sb.append(", #{any()}");
                        args = new Object[]{binary.getLeft(), binary.getRight(), mi.getArguments().get(1)};
                    } else {
                        args = new Object[]{binary.getLeft(), binary.getRight()};
                    }
                    sb.append(")");
                    if (mi.getSelect() == null) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertEquals");
                        t = JavaTemplate.builder((String)sb.toString()).javaParser(this.javaParser(ctx)).staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertEquals"}).build();
                    } else {
                        t = JavaTemplate.builder((String)sb.toString()).javaParser(this.javaParser(ctx)).imports(new String[]{"org.junit.jupiter.api.Assertions"}).build();
                    }
                    return t.apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), args);
                }
                return mi;
            }

            private boolean isEqualBinary(J.MethodInvocation method) {
                if (method.getArguments().isEmpty()) {
                    return false;
                }
                Expression firstArgument = (Expression)method.getArguments().get(0);
                if (!(firstArgument instanceof J.Binary)) {
                    return false;
                }
                J.Binary binary = (J.Binary)firstArgument;
                J.Binary.Type operator = binary.getOperator();
                if (operator != J.Binary.Type.Equal) {
                    return false;
                }
                return binary.getLeft().getType() instanceof JavaType.Primitive && binary.getRight().getType() instanceof JavaType.Primitive && (binary.getLeft().getType() != JavaType.Primitive.String || binary.getRight().getType() != JavaType.Primitive.String);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

