/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class AssertEqualsBooleanToAssertBoolean
extends Recipe {
    private static final MethodMatcher ASSERT_EQUALS = new MethodMatcher("org.junit.jupiter.api.Assertions assertEquals(..)");
    final String displayName = "Replace JUnit `assertEquals(false, <boolean>)` to `assertFalse(<boolean>)` / `assertTrue(<boolean>)`";
    final String description = "Using `assertFalse` or `assertTrue` is simpler and more clear.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            JavaParser.Builder<?, ?> javaParser = null;

            private JavaParser.Builder<?, ?> javaParser(ExecutionContext ctx) {
                if (this.javaParser == null) {
                    this.javaParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"});
                }
                return this.javaParser;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (ASSERT_EQUALS.matches((MethodCall)mi) && this.isBooleanLiteral(mi) && JavaType.Primitive.Boolean == ((Expression)mi.getArguments().get(1)).getType()) {
                    Object[] args;
                    StringBuilder sb = new StringBuilder();
                    String assertMethod = Boolean.parseBoolean(((J.Literal)mi.getArguments().get(0)).getValueSource()) ? "assertTrue" : "assertFalse";
                    Expression assertion = (Expression)mi.getArguments().get(1);
                    if (mi.getSelect() == null) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        this.maybeAddImport("org.junit.jupiter.api.Assertions", assertMethod);
                    } else {
                        sb.append("Assertions.");
                    }
                    sb.append("#{}(#{any(java.lang.Boolean)}");
                    if (mi.getArguments().size() == 3) {
                        args = new Object[]{assertMethod, assertion, mi.getArguments().get(2)};
                        sb.append(", #{any()}");
                    } else {
                        args = new Object[]{assertMethod, mi.getArguments().get(1)};
                    }
                    sb.append(")");
                    JavaTemplate t = mi.getSelect() == null ? JavaTemplate.builder((String)sb.toString()).staticImports(new String[]{String.format("org.junit.jupiter.api.Assertions.%s", assertMethod)}).javaParser(this.javaParser(ctx)).build() : JavaTemplate.builder((String)sb.toString()).imports(new String[]{"org.junit.jupiter.api.Assertions"}).javaParser(this.javaParser(ctx)).build();
                    return (J.MethodInvocation)t.apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), args);
                }
                return mi;
            }

            private boolean isBooleanLiteral(J.MethodInvocation method) {
                if (!method.getArguments().isEmpty() && method.getArguments().get(0) instanceof J.Literal) {
                    J.Literal literal = (J.Literal)method.getArguments().get(0);
                    return JavaType.Primitive.Boolean == literal.getType();
                }
                return false;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

