/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class SimplifyStreamMapToExtracting
extends Recipe {
    private static final MethodMatcher ASSERT_THAT_MATCHER = new MethodMatcher("org.assertj.core.api.Assertions assertThat(*)");
    private static final MethodMatcher STREAM_MATCHER = new MethodMatcher("java.util.Collection stream()");
    private static final MethodMatcher MAP_MATCHER = new MethodMatcher("java.util.stream.Stream map(java.util.function.Function)");
    final String displayName = "Simplify `assertThat(collection.stream().map(...))` to `assertThat(collection).extracting(...)`";
    final String description = "Simplifies AssertJ assertions that use `stream().map()` to extract values from a collection by using the dedicated `extracting()` method instead. This makes the assertion more readable and leverages AssertJ's built-in extraction capabilities.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod(STREAM_MATCHER), new UsesMethod(MAP_MATCHER)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (!ASSERT_THAT_MATCHER.matches((MethodCall)mi)) {
                    return mi;
                }
                if (!MAP_MATCHER.matches((Expression)mi.getArguments().get(0))) {
                    return mi;
                }
                J.MethodInvocation mapCall = (J.MethodInvocation)mi.getArguments().get(0);
                if (!STREAM_MATCHER.matches(mapCall.getSelect())) {
                    return mi;
                }
                return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any(java.lang.Iterable)}).extracting(#{any(java.util.function.Function)})").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{((J.MethodInvocation)mapCall.getSelect()).getSelect(), mapCall.getArguments().get(0)});
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

