/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class SimplifySequencedCollectionAssertions
extends Recipe {
    private static final MethodMatcher ASSERT_THAT_MATCHER = new MethodMatcher("org.assertj.core.api.Assertions assertThat(..)");
    private static final MethodMatcher GET_FIRST_MATCHER = new MethodMatcher("java.util.* getFirst()");
    private static final MethodMatcher GET_LAST_MATCHER = new MethodMatcher("java.util.* getLast()");
    final String displayName = "Simplify AssertJ assertions on SequencedCollection";
    final String description = "Simplify AssertJ assertions on SequencedCollection by using dedicated assertion methods. For example, `assertThat(sequencedCollection.getLast())` can be simplified to `assertThat(sequencedCollection).last()`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(GET_FIRST_MATCHER), new UsesMethod(GET_LAST_MATCHER)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (!ASSERT_THAT_MATCHER.matches((MethodCall)mi) || mi.getArguments().size() != 1) {
                    return mi;
                }
                Expression arg = (Expression)mi.getArguments().get(0);
                if (arg instanceof J.MethodInvocation) {
                    if (GET_FIRST_MATCHER.matches(arg)) {
                        return this.assertThat(mi, (J.MethodInvocation)arg, "first", ctx);
                    }
                    if (GET_LAST_MATCHER.matches(arg)) {
                        return this.assertThat(mi, (J.MethodInvocation)arg, "last", ctx);
                    }
                }
                return mi;
            }

            private J.MethodInvocation assertThat(J.MethodInvocation mi, J.MethodInvocation argMethod, String dedicatedAssertion, ExecutionContext ctx) {
                return (J.MethodInvocation)JavaTemplate.builder((String)("assertThat(#{any(java.lang.Iterable)})." + dedicatedAssertion + "()")).staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{argMethod.getSelect()});
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

