/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class JUnitFailToAssertJFail
extends Recipe {
    private static final String JUNIT = "org.junit.jupiter.api.Assertions";
    private static final String ASSERTJ = "org.assertj.core.api.Assertions";
    private static final MethodMatcher FAIL_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions fail(..)");
    final String displayName = "JUnit fail to AssertJ";
    final String description = "Convert JUnit-style `fail()` to AssertJ's `fail()`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(FAIL_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = method;
                if (!FAIL_MATCHER.matches((MethodCall)mi)) {
                    return mi;
                }
                List args = mi.getArguments();
                if (args.size() == 1) {
                    mi = args.get(0) instanceof J.Empty ? (J.MethodInvocation)JavaTemplate.builder((String)"org.assertj.core.api.Assertions.fail(\"\");").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[0]) : (args.get(0) instanceof J.Literal || TypeUtils.isAssignableTo((String)"java.lang.String", (JavaType)((Expression)args.get(0)).getType()) ? (J.MethodInvocation)JavaTemplate.builder((String)"org.assertj.core.api.Assertions.fail(#{any()});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{args.get(0)}) : (J.MethodInvocation)JavaTemplate.builder((String)"org.assertj.core.api.Assertions.fail(\"\", #{any()});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{args.get(0)}));
                } else {
                    String anyArgs = String.join((CharSequence)",", Collections.nCopies(args.size(), "#{any()}"));
                    mi = (J.MethodInvocation)JavaTemplate.builder((String)("org.assertj.core.api.Assertions.fail(" + anyArgs + ");")).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), args.toArray());
                }
                this.doAfterVisit(new RemoveUnusedImports().getVisitor());
                this.doAfterVisit((TreeVisitor)new UnqualifiedMethodInvocations());
                return mi;
            }

            class UnqualifiedMethodInvocations
            extends JavaIsoVisitor<ExecutionContext> {
                private final MethodMatcher INTERNAL_FAIL_MATCHER = new MethodMatcher("org.assertj.core.api.Assertions fail(..)");

                UnqualifiedMethodInvocations() {
                }

                public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                    J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                    if (!this.INTERNAL_FAIL_MATCHER.matches((MethodCall)mi)) {
                        return mi;
                    }
                    this.maybeRemoveImport("org.junit.jupiter.api.Assertions.fail");
                    this.maybeAddImport(JUnitFailToAssertJFail.ASSERTJ, "fail", false);
                    List arguments = mi.getArguments();
                    String anyArgs = String.join((CharSequence)",", Collections.nCopies(arguments.size(), "#{any()}"));
                    return (J.MethodInvocation)JavaTemplate.builder((String)("fail(" + anyArgs + ");")).staticImports(new String[]{"org.assertj.core.api.Assertions.fail"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), arguments.toArray());
                }
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

