/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class JUnitAssertTrueToAssertThat
extends Recipe {
    private static final MethodMatcher ASSERT_TRUE_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertTrue(boolean, ..)");
    final String displayName = "JUnit `assertTrue` to AssertJ";
    final String description = "Convert JUnit-style `assertTrue()` to AssertJ's `assertThat().isTrue()`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ASSERT_TRUE_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (!ASSERT_TRUE_MATCHER.matches((MethodCall)mi)) {
                    return mi;
                }
                this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat", false);
                List args = mi.getArguments();
                Expression actual = (Expression)args.get(0);
                if (args.size() == 1) {
                    return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any(boolean)}).isTrue();").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{actual});
                }
                Expression message = (Expression)args.get(1);
                return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any()}).as(#{any(String)}).isTrue();").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{actual, message});
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

