/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class JUnitAssertInstanceOfToAssertThat
extends Recipe {
    private static final MethodMatcher ASSERT_INSTANCE_OF_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertInstanceOf(..)", true);
    final String displayName = "JUnit `assertInstanceOf` to AssertJ";
    final String description = "Convert JUnit-style `assertInstanceOf()` to AssertJ's `assertThat().isInstanceOf()`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ASSERT_INSTANCE_OF_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (!ASSERT_INSTANCE_OF_MATCHER.matches((MethodCall)mi)) {
                    return mi;
                }
                this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat", false);
                Expression expected = (Expression)mi.getArguments().get(0);
                Expression actual = (Expression)mi.getArguments().get(1);
                if (mi.getArguments().size() == 2) {
                    return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any()}).isInstanceOf(#{any()});").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{actual, expected});
                }
                Expression messageOrSupplier = (Expression)mi.getArguments().get(2);
                return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any()}).as(#{any()}).isInstanceOf(#{any()});").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{actual, messageOrSupplier, expected});
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

