/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.staticanalysis.SimplifyDurationCreationUnits;

public class AdoptAssertJDurationAssertions
extends Recipe {
    private static final String DURATION_ASSERT_HAS_LONG = "org.assertj.core.api.AbstractDurationAssert has*(long)";
    private static final String INTEGER_ASSERT_IS_EQUAL_TO = "org.assertj.core.api.AbstractIntegerAssert isEqualTo(..)";
    private static final String INTEGER_ASSERT_IS_GREATER_THAN = "org.assertj.core.api.AbstractIntegerAssert isGreaterThan(..)";
    private static final String INTEGER_ASSERT_IS_LESS_THAN = "org.assertj.core.api.AbstractIntegerAssert isLessThan(..)";
    private static final String LONG_ASSERT_IS_LESS_THAN = "org.assertj.core.api.AbstractLongAssert isLessThan(..)";
    private static final String LONG_ASSERT_IS_GREATER_THAN = "org.assertj.core.api.AbstractLongAssert isGreaterThan(..)";
    private static final String LONG_ASSERT_IS_EQUAL_TO = "org.assertj.core.api.AbstractLongAssert isEqualTo(..)";
    private static final MethodMatcher ASSERT_THAT_MATCHER = new MethodMatcher("org.assertj.core.api.Assertions assertThat(..)");
    private static final MethodMatcher GET_NANO_MATCHER = new MethodMatcher("java.time.Duration getNano()");
    private static final MethodMatcher GET_SECONDS_MATCHER = new MethodMatcher("java.time.Duration getSeconds()");
    private static final MethodMatcher AS_MATCHER = new MethodMatcher("org.assertj.core.api.AbstractObjectAssert as(..)");
    private static final MethodMatcher TIME_UNIT_MATCHERS = new MethodMatcher("org.assertj.core.api.AbstractDurationAssert has*(long)", true);
    private static final List<MethodMatcher> IS_MATCHERS = Arrays.asList(new MethodMatcher("org.assertj.core.api.AbstractIntegerAssert isEqualTo(..)", true), new MethodMatcher("org.assertj.core.api.AbstractIntegerAssert isGreaterThan(..)", true), new MethodMatcher("org.assertj.core.api.AbstractIntegerAssert isLessThan(..)", true), new MethodMatcher("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true), new MethodMatcher("org.assertj.core.api.AbstractLongAssert isGreaterThan(..)", true), new MethodMatcher("org.assertj.core.api.AbstractLongAssert isLessThan(..)", true));
    private static final Map<String, String> METHOD_MAP = new HashMap<String, String>(){
        {
            this.put("getSeconds", "hasSeconds");
            this.put("getNano", "hasNanos");
            this.put("hasNanos", "hasMillis");
            this.put("hasMillis", "hasSeconds");
            this.put("hasSeconds", "hasMinutes");
            this.put("hasMinutes", "hasHours");
            this.put("hasHours", "hasDays");
            this.put("isGreaterThan", "isPositive");
            this.put("isLessThan", "isNegative");
            this.put("isEqualTo", "isZero");
        }
    };
    final String displayName = "Adopt AssertJ Duration assertions";
    final String description = "Adopt AssertJ `DurationAssert` assertions for more expressive messages.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(DURATION_ASSERT_HAS_LONG, true), new UsesMethod(INTEGER_ASSERT_IS_EQUAL_TO, true), new UsesMethod(INTEGER_ASSERT_IS_GREATER_THAN, true), new UsesMethod(INTEGER_ASSERT_IS_LESS_THAN, true), new UsesMethod(LONG_ASSERT_IS_EQUAL_TO, true), new UsesMethod(LONG_ASSERT_IS_GREATER_THAN, true), new UsesMethod(LONG_ASSERT_IS_LESS_THAN, true)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (TIME_UNIT_MATCHERS.matches((MethodCall)mi)) {
                    return this.simplifyTimeUnits(mi, ctx);
                }
                if (IS_MATCHERS.stream().anyMatch(matcher -> matcher.matches((MethodCall)mi))) {
                    return this.simplifyMultipleAssertions(mi, ctx);
                }
                return mi;
            }

            private J.MethodInvocation simplifyMultipleAssertions(J.MethodInvocation m, ExecutionContext ctx) {
                Expression isEqualToArg = (Expression)m.getArguments().get(0);
                Expression select = m.getSelect();
                ArrayList<Object> templateParameters = new ArrayList<Object>();
                templateParameters.add(null);
                Expression asDescription = null;
                if (AS_MATCHER.matches(select)) {
                    asDescription = (Expression)((J.MethodInvocation)select).getArguments().get(0);
                    select = ((J.MethodInvocation)select).getSelect();
                    templateParameters.add(asDescription);
                }
                if (!ASSERT_THAT_MATCHER.matches(select)) {
                    return m;
                }
                Expression assertThatArgumentExpr = (Expression)((J.MethodInvocation)select).getArguments().get(0);
                if (!(assertThatArgumentExpr instanceof J.MethodInvocation)) {
                    return m;
                }
                J.MethodInvocation assertThatArg = (J.MethodInvocation)assertThatArgumentExpr;
                if (this.isZero(isEqualToArg) && this.checkIfRelatedToDuration(assertThatArg)) {
                    String formatted_template = this.formatTemplate("assertThat(#{any()}).%s();", m.getSimpleName(), asDescription);
                    templateParameters.set(0, assertThatArg);
                    return this.applyTemplate(ctx, m, formatted_template, templateParameters.toArray());
                }
                if (GET_NANO_MATCHER.matches((MethodCall)assertThatArg) || GET_SECONDS_MATCHER.matches((MethodCall)assertThatArg)) {
                    Expression assertThatArgSelect = assertThatArg.getSelect();
                    String methodName = assertThatArg.getSimpleName();
                    String formatted_template = this.formatTemplate("assertThat(#{any()}).%s(#{any()});", methodName, asDescription);
                    templateParameters.set(0, assertThatArgSelect);
                    templateParameters.add(isEqualToArg);
                    return this.applyTemplate(ctx, m, formatted_template, templateParameters.toArray());
                }
                return m;
            }

            private boolean isZero(Expression isEqualToArg) {
                if (isEqualToArg instanceof J.Literal) {
                    J.Literal literal = (J.Literal)isEqualToArg;
                    return literal.getValue() instanceof Number && ((Number)literal.getValue()).longValue() == 0L;
                }
                return false;
            }

            private J.MethodInvocation simplifyTimeUnits(J.MethodInvocation m, ExecutionContext ctx) {
                Expression arg = (Expression)m.getArguments().get(0);
                Long argValue = SimplifyDurationCreationUnits.getConstantIntegralValue((Expression)arg);
                if (argValue == null) {
                    return m;
                }
                List<Object> unitInfo = this.getUnitInfo(m.getSimpleName(), Math.toIntExact(argValue));
                String methodName = (String)unitInfo.get(0);
                int methodArg = (Integer)unitInfo.get(1);
                if (!m.getSimpleName().equals(methodName)) {
                    String template = String.format("#{any()}.%s(%d)", methodName, methodArg);
                    return this.applyTemplate(ctx, m, template, m.getSelect());
                }
                return m;
            }

            private List<Object> getUnitInfo(String name, int argValue) {
                int timeLength;
                if ("hasSeconds".equals(name) || "hasMinutes".equals(name)) {
                    timeLength = 60;
                } else if ("hasNanos".equals(name) || "hasMillis".equals(name)) {
                    timeLength = 1000;
                } else if ("hasHours".equals(name)) {
                    timeLength = 24;
                } else {
                    return Arrays.asList(name, argValue);
                }
                if (argValue % timeLength == 0) {
                    String newName = (String)METHOD_MAP.get(name);
                    return this.getUnitInfo(newName, argValue / timeLength);
                }
                return Arrays.asList(name, argValue);
            }

            private J.MethodInvocation applyTemplate(ExecutionContext ctx, J.MethodInvocation m, String template, Object ... parameters) {
                J.MethodInvocation invocation = (J.MethodInvocation)JavaTemplate.builder((String)template).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), m.getCoordinates().replace(), parameters);
                if (invocation.getPadding().getSelect() != null && m.getPadding().getSelect() != null) {
                    return invocation.getPadding().withSelect(invocation.getPadding().getSelect().withAfter(m.getPadding().getSelect().getAfter()));
                }
                return invocation;
            }

            private boolean checkIfRelatedToDuration(J.MethodInvocation argument) {
                if (argument.getSelect() != null && argument.getSelect() instanceof J.MethodInvocation) {
                    J.MethodInvocation selectMethod = (J.MethodInvocation)argument.getSelect();
                    return TypeUtils.isOfType((JavaType)selectMethod.getType(), (JavaType)JavaType.buildType((String)"java.time.Duration"));
                }
                return false;
            }

            private String formatTemplate(String template, String methodName, Object asDescriptionArg) {
                String replacementMethod = (String)METHOD_MAP.get(methodName);
                if (asDescriptionArg == null) {
                    return String.format(template, replacementMethod);
                }
                StringBuilder newTemplate = new StringBuilder(template);
                newTemplate.insert(newTemplate.indexOf(").") + 1, ".as(#{any()})");
                return String.format(newTemplate.toString(), replacementMethod);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

