/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.arquillian;

import java.util.Comparator;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;

public class ReplaceArquillianInSequenceAnnotation
extends Recipe {
    final String displayName = "Arquillian JUnit 4 `@InSequence` to JUnit Jupiter `@Order`";
    final String description = "Transforms the Arquillian JUnit 4 `@InSequence` to the JUnit Jupiter `@Order`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.jboss.arquillian.junit.InSequence", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final String IN_SEQUENCE = "org.jboss.arquillian.junit.InSequence";
            private final String TEST_METHOD_ORDER = "org.junit.jupiter.api.TestMethodOrder";
            private final String METHOD_ORDERER = "org.junit.jupiter.api.MethodOrderer";
            private final AnnotationMatcher IN_SEQUENCE_MATCHER = new AnnotationMatcher("@org.jboss.arquillian.junit.InSequence");
            private final AnnotationMatcher TEST_METHOD_ORDER_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.TestMethodOrder");

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                this.doAfterVisit(new ChangeType("org.jboss.arquillian.junit.InSequence", "org.junit.jupiter.api.Order", Boolean.valueOf(true)).getVisitor());
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.ClassDeclaration classWithInSequenceMethods;
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                if (((AnnotationService)this.service(AnnotationService.class)).matches(this.updateCursor((Tree)m), this.IN_SEQUENCE_MATCHER) && (classWithInSequenceMethods = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class)) != null) {
                    this.doAfterVisit((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                            if (cd.getName().equals((Object)classWithInSequenceMethods.getName()) && !((AnnotationService)this.service(AnnotationService.class)).matches(this.updateCursor((Tree)cd), TEST_METHOD_ORDER_MATCHER)) {
                                this.maybeAddImport("org.junit.jupiter.api.MethodOrderer");
                                this.maybeAddImport("org.junit.jupiter.api.TestMethodOrder");
                                return (J.ClassDeclaration)JavaTemplate.builder((String)"@TestMethodOrder(MethodOrderer.OrderAnnotation.class)").imports(new String[]{"org.junit.jupiter.api.MethodOrderer", "org.junit.jupiter.api.TestMethodOrder"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build().apply(this.getCursor(), classDecl.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                            }
                            return cd;
                        }
                    });
                }
                return m;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

