/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class SimplifyTestThrows
extends Recipe {
    private static final String FQN_JAVA_LANG_EXCEPTION = "java.lang.Exception";

    public String getDisplayName() {
        return "Simplify `throws` statements of tests";
    }

    public String getDescription() {
        return "Replace all thrown exception classes of test method signatures by `Exception`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.junit.jupiter.api.Test", Boolean.valueOf(false)), new UsesType("org.junit.jupiter.api.TestTemplate", Boolean.valueOf(false)), new UsesType("org.junit.jupiter.api.RepeatedTest", Boolean.valueOf(false)), new UsesType("org.junit.jupiter.params.ParameterizedTest", Boolean.valueOf(false)), new UsesType("org.junit.jupiter.api.TestFactory", Boolean.valueOf(false))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                if (TypeUtils.isOverride((JavaType.Method)m.getMethodType()) || !this.hasJUnit5MethodAnnotation(method) || this.throwsNothingOrException(method)) {
                    return m;
                }
                for (NameTree t : m.getThrows()) {
                    JavaType.FullyQualified type = TypeUtils.asFullyQualified((JavaType)t.getType());
                    if (type == null) continue;
                    this.maybeRemoveImport(type);
                }
                J.Identifier exceptionIdentifier = new J.Identifier(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, Collections.emptyList(), "Exception", (JavaType)JavaType.ShallowClass.build((String)SimplifyTestThrows.FQN_JAVA_LANG_EXCEPTION), null);
                return m.withThrows(Collections.singletonList(exceptionIdentifier));
            }

            private boolean throwsNothingOrException(J.MethodDeclaration method) {
                @Nullable List th = method.getThrows();
                if (th == null || th.isEmpty()) {
                    return true;
                }
                return th.size() == 1 && TypeUtils.isOfClassType((JavaType)((NameTree)th.get(0)).getType(), (String)SimplifyTestThrows.FQN_JAVA_LANG_EXCEPTION);
            }

            private boolean hasJUnit5MethodAnnotation(J.MethodDeclaration method) {
                for (J.Annotation a : method.getLeadingAnnotations()) {
                    if (!TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.Test") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.TestTemplate") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.RepeatedTest") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.params.ParameterizedTest") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.TestFactory")) continue;
                    return true;
                }
                return false;
            }
        });
    }
}

