/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class AddMissingTestBeforeAfterAnnotations
extends Recipe {
    public String getDisplayName() {
        return "Add missing `@BeforeEach`, `@AfterEach`, `@Test` to overriding methods";
    }

    public String getDescription() {
        return "Adds `@BeforeEach`, `@AfterEach`, `@Test` to methods overriding superclass methods if the annotations are present on the superclass method.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (classDecl.getExtends() != null) {
                    return (J.ClassDeclaration)SearchResult.found((Tree)classDecl);
                }
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }
        }, (TreeVisitor)new AddMissingTestBeforeAfterAnnotationsVisitor());
    }

    @NonNull
    public String toString() {
        return "AddMissingTestBeforeAfterAnnotations()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddMissingTestBeforeAfterAnnotations)) {
            return false;
        }
        AddMissingTestBeforeAfterAnnotations other = (AddMissingTestBeforeAfterAnnotations)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddMissingTestBeforeAfterAnnotations;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class AddMissingTestBeforeAfterAnnotationsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private AddMissingTestBeforeAfterAnnotationsVisitor() {
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            if (!method.hasModifier(J.Modifier.Type.Static) && !method.isConstructor()) {
                JavaType.Method currMethod = method.getMethodType();
                Optional superMethod = TypeUtils.findOverriddenMethod((JavaType.Method)currMethod);
                while (superMethod.isPresent()) {
                    method = this.maybeAddMissingAnnotation(method, (JavaType.Method)superMethod.get(), LifecyleAnnotation.BEFORE_EACH, ctx);
                    method = this.maybeAddMissingAnnotation(method, (JavaType.Method)superMethod.get(), LifecyleAnnotation.AFTER_EACH, ctx);
                    method = this.maybeAddMissingAnnotation(method, (JavaType.Method)superMethod.get(), LifecyleAnnotation.TEST, ctx);
                    currMethod = (JavaType.Method)superMethod.get();
                    superMethod = TypeUtils.findOverriddenMethod((JavaType.Method)currMethod);
                }
            }
            return super.visitMethodDeclaration(method, (Object)ctx);
        }

        private J.MethodDeclaration maybeAddMissingAnnotation(J.MethodDeclaration method, JavaType.Method superMethod, LifecyleAnnotation la, ExecutionContext ctx) {
            if (la.needsAnnotation(method, superMethod)) {
                this.maybeAddImport(la.newAnnotation);
                return (J.MethodDeclaration)JavaTemplate.builder((String)la.newAnnotationSimple).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9"})).imports(new String[]{la.newAnnotation}).build().apply(this.getCursor(), method.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
            }
            return method;
        }
    }

    static enum LifecyleAnnotation {
        BEFORE_EACH("org.junit.Before", "org.junit.jupiter.api.BeforeEach"),
        AFTER_EACH("org.junit.After", "org.junit.jupiter.api.AfterEach"),
        TEST("org.junit.Test", "org.junit.jupiter.api.Test");

        String newAnnotation;
        String newAnnotationSimple;
        private AnnotationMatcher newAnnotationMatcher;
        private Predicate<JavaType.FullyQualified> newAnnotationPredicate;
        private Predicate<JavaType.FullyQualified> oldAnnotationPredicate;

        private LifecyleAnnotation(String oldAnnotation, String newAnnotation) {
            this.newAnnotation = newAnnotation;
            this.newAnnotationSimple = "@" + newAnnotation.substring(newAnnotation.lastIndexOf(".") + 1);
            this.newAnnotationMatcher = new AnnotationMatcher("@" + newAnnotation);
            this.newAnnotationPredicate = n -> TypeUtils.isOfClassType((JavaType)n, (String)newAnnotation);
            this.oldAnnotationPredicate = n -> TypeUtils.isOfClassType((JavaType)n, (String)oldAnnotation);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean needsAnnotation(J.MethodDeclaration method, JavaType.Method superMethod) {
            boolean superMethodHasAnnotation = superMethod.getAnnotations().stream().anyMatch(this.oldAnnotationPredicate.or(this.newAnnotationPredicate));
            if (!superMethodHasAnnotation) return false;
            if (method.getAllAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)this.newAnnotationMatcher).matches(arg_0))) return false;
            return true;
        }
    }
}

