/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class AssertFalseEqualsToAssertNotEquals
extends Recipe {
    private static final MethodMatcher ASSERT_FALSE = new MethodMatcher("org.junit.jupiter.api.Assertions assertFalse(..)");

    public String getDisplayName() {
        return "Replace JUnit `assertFalse(a.equals(b))` to `assertNotEquals(a,b)`";
    }

    public String getDescription() {
        return "Using `assertNotEquals(a,b)` is simpler and more clear.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ASSERT_FALSE), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            JavaParser.Builder<?, ?> javaParser = null;

            private JavaParser.Builder<?, ?> javaParser(ExecutionContext ctx) {
                if (this.javaParser == null) {
                    this.javaParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9"});
                }
                return this.javaParser;
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (ASSERT_FALSE.matches((MethodCall)method) && this.isEquals((Expression)method.getArguments().get(0))) {
                    Object[] objectArray;
                    StringBuilder sb = new StringBuilder();
                    if (mi.getSelect() == null) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertNotEquals");
                    } else {
                        sb.append("Assertions.");
                    }
                    sb.append("assertNotEquals(#{any(java.lang.Object)}, #{any(java.lang.Object)}");
                    if (mi.getArguments().size() == 2) {
                        sb.append(", #{any()}");
                    }
                    sb.append(")");
                    J.MethodInvocation s = (J.MethodInvocation)method.getArguments().get(0);
                    if (method.getArguments().size() == 2) {
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = s.getSelect();
                        objectArray2[1] = s.getArguments().get(0);
                        objectArray = objectArray2;
                        objectArray2[2] = mi.getArguments().get(1);
                    } else {
                        Object[] objectArray3 = new Object[2];
                        objectArray3[0] = s.getSelect();
                        objectArray = objectArray3;
                        objectArray3[1] = s.getArguments().get(0);
                    }
                    Object[] args = objectArray;
                    JavaTemplate t = mi.getSelect() == null ? JavaTemplate.builder((String)sb.toString()).contextSensitive().staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertNotEquals"}).javaParser(this.javaParser(ctx)).build() : JavaTemplate.builder((String)sb.toString()).contextSensitive().imports(new String[]{"org.junit.jupiter.api.Assertions"}).javaParser(this.javaParser(ctx)).build();
                    return t.apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), args);
                }
                return mi;
            }

            private boolean isEquals(Expression expr) {
                if (!(expr instanceof J.MethodInvocation)) {
                    return false;
                }
                J.MethodInvocation methodInvocation = (J.MethodInvocation)expr;
                return "equals".equals(methodInvocation.getName().getSimpleName()) && methodInvocation.getArguments().size() == 1;
            }
        });
    }
}

