/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class JUnitAssertArrayEqualsToAssertThat
extends Recipe {
    private static final String JUNIT_QUALIFIED_ASSERTIONS_CLASS_NAME = "org.junit.jupiter.api.Assertions";

    public String getDisplayName() {
        return "JUnit `assertArrayEquals` To AssertJ";
    }

    public String getDescription() {
        return "Convert JUnit-style `assertArrayEquals()` to AssertJ's `assertThat().contains()` equivalents.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(JUNIT_QUALIFIED_ASSERTIONS_CLASS_NAME, Boolean.valueOf(false)), (TreeVisitor)new AssertArrayEqualsToAssertThatVisitor());
    }

    public static class AssertArrayEqualsToAssertThatVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher JUNIT_ASSERT_EQUALS = new MethodMatcher("org.junit.jupiter.api.Assertions assertArrayEquals(..)");
        private JavaParser.Builder<?, ?> assertionsParser;

        private JavaParser.Builder<?, ?> assertionsParser(ExecutionContext ctx) {
            if (this.assertionsParser == null) {
                this.assertionsParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"});
            }
            return this.assertionsParser;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (!JUNIT_ASSERT_EQUALS.matches((MethodCall)method)) {
                return method;
            }
            List args = method.getArguments();
            Expression expected = (Expression)args.get(0);
            Expression actual = (Expression)args.get(1);
            this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
            this.maybeRemoveImport(JUnitAssertArrayEqualsToAssertThat.JUNIT_QUALIFIED_ASSERTIONS_CLASS_NAME);
            if (args.size() == 2) {
                return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{anyArray()}).containsExactly(#{anyArray()});").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(this.assertionsParser(ctx)).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{actual, expected});
            }
            if (args.size() == 3 && !AssertArrayEqualsToAssertThatVisitor.isFloatingPointType((Expression)args.get(2))) {
                Expression message = (Expression)args.get(2);
                JavaTemplate.Builder template = TypeUtils.isString((JavaType)message.getType()) ? JavaTemplate.builder((String)"assertThat(#{anyArray()}).as(#{any(String)}).containsExactly(#{anyArray()});") : JavaTemplate.builder((String)"assertThat(#{anyArray()}).as(#{any(java.util.function.Supplier)}).containsExactly(#{anyArray()});");
                return (J.MethodInvocation)template.staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(this.assertionsParser(ctx)).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{actual, message, expected});
            }
            if (args.size() == 3) {
                this.maybeAddImport("org.assertj.core.api.Assertions", "within");
                return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{anyArray()}).containsExactly(#{anyArray()}, within(#{any()}));").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat", "org.assertj.core.api.Assertions.within"}).javaParser(this.assertionsParser(ctx)).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{actual, expected, args.get(2)});
            }
            Expression message = (Expression)args.get(3);
            this.maybeAddImport("org.assertj.core.api.Assertions", "within");
            JavaTemplate.Builder template = TypeUtils.isString((JavaType)message.getType()) ? JavaTemplate.builder((String)"assertThat(#{anyArray()}).as(#{any(String)}).containsExactly(#{anyArray()}, within(#{any()}));") : JavaTemplate.builder((String)"assertThat(#{anyArray()}).as(#{any(java.util.function.Supplier)}).containsExactly(#{anyArray()}, within(#{}));");
            return (J.MethodInvocation)template.staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat", "org.assertj.core.api.Assertions.within"}).javaParser(this.assertionsParser(ctx)).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{actual, message, expected, args.get(2)});
        }

        private static boolean isFloatingPointType(Expression expression) {
            JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified((JavaType)expression.getType());
            if (fullyQualified != null) {
                String typeName = fullyQualified.getFullyQualifiedName();
                return "java.lang.Double".equals(typeName) || "java.lang.Float".equals(typeName);
            }
            JavaType.Primitive parameterType = TypeUtils.asPrimitive((JavaType)expression.getType());
            return parameterType == JavaType.Primitive.Double || parameterType == JavaType.Primitive.Float;
        }
    }
}

