/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.testcontainers;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class ExplicitContainerImage
extends Recipe {
    @Option(displayName="Container class", description="The fully qualified name of the container class to use.", example="org.testcontainers.containers.NginxContainer")
    private final String containerClass;
    @Option(displayName="Image to use", description="The image to use for the container.", example="nginx:1.9.4")
    private final String image;
    @Option(displayName="Parse image", description="Whether to call `DockerImageName.parse(image)`.", required=false)
    private final Boolean parseImage;

    public String getDisplayName() {
        return "Add image argument to container constructor";
    }

    public String getDescription() {
        return "Set the image to use for a container explicitly if unset, rather than relying on the default image for the container class.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher methodMatcher = new MethodMatcher(this.containerClass + " <constructor>()");
        return Preconditions.check((TreeVisitor)new UsesMethod(methodMatcher), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J.NewClass nc = super.visitNewClass(newClass, (Object)ctx);
                if (methodMatcher.matches((MethodCall)newClass)) {
                    return nc.withArguments(Arrays.asList(this.getConstructorArgument(newClass)));
                }
                return nc;
            }

            @NotNull
            private Expression getConstructorArgument(J.NewClass newClass) {
                if (ExplicitContainerImage.this.parseImage != null && ExplicitContainerImage.this.parseImage.booleanValue()) {
                    this.maybeAddImport("org.testcontainers.utility.DockerImageName");
                    return (Expression)JavaTemplate.builder((String)("DockerImageName.parse(\"" + ExplicitContainerImage.this.image + "\")")).imports(new String[]{"org.testcontainers.utility.DockerImageName"}).javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"testcontainers"})).build().apply(this.getCursor(), ((Expression)newClass.getArguments().get(0)).getCoordinates().replace(), new Object[0]).withPrefix(Space.EMPTY);
                }
                return new J.Literal(UUID.randomUUID(), Space.EMPTY, Markers.EMPTY, (Object)ExplicitContainerImage.this.image, "\"" + ExplicitContainerImage.this.image + "\"", null, JavaType.Primitive.String);
            }
        });
    }

    @ConstructorProperties(value={"containerClass", "image", "parseImage"})
    public ExplicitContainerImage(String containerClass, String image, Boolean parseImage) {
        this.containerClass = containerClass;
        this.image = image;
        this.parseImage = parseImage;
    }
}

