/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.jmockit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;

class ArgumentMatchersRewriter {
    private static final Set<String> JMOCKIT_ARGUMENT_MATCHERS = new HashSet<String>();
    private static final Map<String, String> MOCKITO_COLLECTION_MATCHERS;
    private final JavaVisitor<ExecutionContext> visitor;
    private final ExecutionContext ctx;
    private final J.Block expectationsBlock;

    ArgumentMatchersRewriter(JavaVisitor<ExecutionContext> visitor, ExecutionContext ctx, J.Block expectationsBlock) {
        this.visitor = visitor;
        this.ctx = ctx;
        this.expectationsBlock = expectationsBlock;
    }

    J.Block rewriteExpectationsBlock() {
        ArrayList<Object> newStatements = new ArrayList<Object>(this.expectationsBlock.getStatements().size());
        for (Statement expectationStatement : this.expectationsBlock.getStatements()) {
            if (!(expectationStatement instanceof J.MethodInvocation)) {
                newStatements.add(expectationStatement);
                continue;
            }
            newStatements.add(this.rewriteMethodInvocation((J.MethodInvocation)expectationStatement));
        }
        return this.expectationsBlock.withStatements(newStatements);
    }

    private J.MethodInvocation rewriteMethodInvocation(J.MethodInvocation invocation) {
        if (invocation.getSelect() instanceof J.MethodInvocation) {
            invocation = invocation.withSelect((Expression)this.rewriteMethodInvocation((J.MethodInvocation)invocation.getSelect()));
        }
        boolean hasArgumentMatcher = false;
        List arguments = invocation.getArguments();
        for (Expression methodArgument : arguments) {
            if (!ArgumentMatchersRewriter.isJmockitArgumentMatcher(methodArgument)) continue;
            hasArgumentMatcher = true;
            break;
        }
        if (!hasArgumentMatcher) {
            return invocation;
        }
        ArrayList<Expression> newArguments = new ArrayList<Expression>(arguments.size());
        for (Expression argument : arguments) {
            newArguments.add(this.rewriteMethodArgument(argument));
        }
        return invocation.withArguments(newArguments);
    }

    private Expression rewriteMethodArgument(Expression methodArgument) {
        if (!ArgumentMatchersRewriter.isJmockitArgumentMatcher(methodArgument)) {
            if (methodArgument instanceof J.Literal) {
                return this.rewritePrimitiveToArgumentMatcher((J.Literal)methodArgument);
            }
            if (methodArgument instanceof J.Identifier) {
                return this.rewriteIdentifierToArgumentMatcher((J.Identifier)methodArgument);
            }
            if (methodArgument instanceof J.FieldAccess) {
                return this.rewriteIdentifierToArgumentMatcher(((J.FieldAccess)methodArgument).getName());
            }
            throw new IllegalStateException("Unexpected method argument: " + methodArgument + ", class: " + methodArgument.getClass());
        }
        if (!(methodArgument instanceof J.TypeCast)) {
            String argumentMatcher = ((J.Identifier)methodArgument).getSimpleName();
            String template = argumentMatcher + "()";
            return this.applyArgumentTemplate(methodArgument, argumentMatcher, template, new ArrayList<Object>());
        }
        return this.rewriteTypeCastToArgumentMatcher(methodArgument);
    }

    private Expression applyArgumentTemplate(Expression methodArgument, String argumentMatcher, String template, List<Object> templateParams) {
        this.visitor.maybeAddImport("org.mockito.Mockito", argumentMatcher);
        return (Expression)JavaTemplate.builder((String)template).javaParser(JavaParser.fromJavaVersion().classpathFromResources(this.ctx, new String[]{"mockito-core-3.12"})).staticImports(new String[]{"org.mockito.Mockito." + argumentMatcher}).build().apply(new Cursor(this.visitor.getCursor(), (Object)methodArgument), methodArgument.getCoordinates().replace(), templateParams.toArray());
    }

    private Expression applyClassArgumentTemplate(Expression methodArgument, String className) {
        return (Expression)JavaTemplate.builder((String)"#{}.class").javaParser(JavaParser.fromJavaVersion()).build().apply(new Cursor(this.visitor.getCursor(), (Object)methodArgument), methodArgument.getCoordinates().replace(), new Object[]{className});
    }

    private Expression rewriteFullyQualifiedArgument(Expression methodArgument, String className, String fqn) {
        String template;
        ArrayList<Object> templateParams = new ArrayList<Object>();
        String argumentMatcher = "any";
        if (MOCKITO_COLLECTION_MATCHERS.containsKey(fqn)) {
            argumentMatcher = MOCKITO_COLLECTION_MATCHERS.get(fqn);
            template = argumentMatcher + "()";
        } else if (fqn.equals("java.lang.String")) {
            argumentMatcher = "anyString";
            template = argumentMatcher + "()";
        } else {
            templateParams.add(this.applyClassArgumentTemplate(methodArgument, className));
            template = "any(#{any(java.lang.Class)})";
        }
        return this.applyArgumentTemplate(methodArgument, argumentMatcher, template, templateParams);
    }

    private Expression rewriteIdentifierToArgumentMatcher(J.Identifier methodArgument) {
        if (methodArgument.getType() == null) {
            throw new IllegalStateException("Missing type information for identifier: " + methodArgument);
        }
        if (!(methodArgument.getType() instanceof JavaType.FullyQualified)) {
            throw new IllegalStateException("Unexpected identifier type: " + methodArgument.getType());
        }
        JavaType.FullyQualified type = (JavaType.FullyQualified)methodArgument.getType();
        return this.rewriteFullyQualifiedArgument((Expression)methodArgument, type.getClassName(), type.getFullyQualifiedName());
    }

    private Expression rewriteTypeCastToArgumentMatcher(Expression methodArgument) {
        String fqn;
        String className;
        J.TypeCast tc = (J.TypeCast)methodArgument;
        JavaType typeCastType = tc.getType();
        if (typeCastType instanceof JavaType.Parameterized) {
            className = ((JavaType.Parameterized)typeCastType).getType().getClassName();
            fqn = ((JavaType.Parameterized)typeCastType).getType().getFullyQualifiedName();
        } else if (typeCastType instanceof JavaType.Class) {
            className = ((JavaType.Class)typeCastType).getClassName();
            fqn = ((JavaType.Class)typeCastType).getFullyQualifiedName();
        } else {
            throw new IllegalStateException("Unexpected J.TypeCast type: " + typeCastType);
        }
        return this.rewriteFullyQualifiedArgument((Expression)tc, className, fqn);
    }

    private Expression rewritePrimitiveToArgumentMatcher(J.Literal methodArgument) {
        String argumentMatcher;
        JavaType.Primitive primitiveType = methodArgument.getType();
        switch (Objects.requireNonNull(primitiveType)) {
            case Boolean: {
                argumentMatcher = "anyBoolean";
                break;
            }
            case Byte: {
                argumentMatcher = "anyByte";
                break;
            }
            case Char: {
                argumentMatcher = "anyChar";
                break;
            }
            case Double: {
                argumentMatcher = "anyDouble";
                break;
            }
            case Float: {
                argumentMatcher = "anyFloat";
                break;
            }
            case Int: {
                argumentMatcher = "anyInt";
                break;
            }
            case Long: {
                argumentMatcher = "anyLong";
                break;
            }
            case Short: {
                argumentMatcher = "anyShort";
                break;
            }
            case String: {
                argumentMatcher = "anyString";
                break;
            }
            case Null: {
                argumentMatcher = "isNull";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected primitive type: " + primitiveType);
            }
        }
        String template = argumentMatcher + "()";
        return this.applyArgumentTemplate((Expression)methodArgument, argumentMatcher, template, new ArrayList<Object>());
    }

    private static boolean isJmockitArgumentMatcher(Expression expression) {
        if (expression instanceof J.TypeCast) {
            expression = ((J.TypeCast)expression).getExpression();
        }
        if (!(expression instanceof J.Identifier)) {
            return false;
        }
        J.Identifier identifier = (J.Identifier)expression;
        return JMOCKIT_ARGUMENT_MATCHERS.contains(identifier.getSimpleName());
    }

    static {
        JMOCKIT_ARGUMENT_MATCHERS.add("anyString");
        JMOCKIT_ARGUMENT_MATCHERS.add("anyInt");
        JMOCKIT_ARGUMENT_MATCHERS.add("anyLong");
        JMOCKIT_ARGUMENT_MATCHERS.add("anyDouble");
        JMOCKIT_ARGUMENT_MATCHERS.add("anyFloat");
        JMOCKIT_ARGUMENT_MATCHERS.add("anyBoolean");
        JMOCKIT_ARGUMENT_MATCHERS.add("anyByte");
        JMOCKIT_ARGUMENT_MATCHERS.add("anyChar");
        JMOCKIT_ARGUMENT_MATCHERS.add("anyShort");
        JMOCKIT_ARGUMENT_MATCHERS.add("any");
        MOCKITO_COLLECTION_MATCHERS = new HashMap<String, String>();
        MOCKITO_COLLECTION_MATCHERS.put("java.util.List", "anyList");
        MOCKITO_COLLECTION_MATCHERS.put("java.util.Set", "anySet");
        MOCKITO_COLLECTION_MATCHERS.put("java.util.Collection", "anyCollection");
        MOCKITO_COLLECTION_MATCHERS.put("java.util.Iterable", "anyIterable");
        MOCKITO_COLLECTION_MATCHERS.put("java.util.Map", "anyMap");
    }
}

