/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis.maven;

import java.text.Normalizer;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;

public final class MavenJavadocNonAsciiRecipe
extends Recipe {
    private final String displayName = "Remove non-ASCII characters from Javadoc";
    private final String description = "Maven's javadoc-plugin configuration does not support non-ASCII characters. What makes it tricky is the error is very ambiguous and doesn't help in any way. This recipe removes those non-ASCII characters.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public Space visitSpace(@Nullable Space space, Space.Location loc, ExecutionContext ctx) {
                Space sp = super.visitSpace(space, loc, (Object)ctx);
                return sp.withComments(ListUtils.map((List)sp.getComments(), c -> {
                    if (c instanceof Javadoc.DocComment) {
                        Javadoc.DocComment jdc = (Javadoc.DocComment)c;
                        return jdc.withBody(ListUtils.map((List)jdc.getBody(), jd -> {
                            if (jd instanceof Javadoc.Text) {
                                Javadoc.Text jdText = (Javadoc.Text)jd;
                                String newText = Normalizer.normalize(jdText.getText(), Normalizer.Form.NFKD).replaceAll("[^\\p{ASCII}]", "");
                                return jdText.getText().equals(newText) ? jd : jdText.withText(newText);
                            }
                            return jd;
                        }));
                    }
                    return c;
                }));
            }
        };
    }

    @Generated
    public MavenJavadocNonAsciiRecipe() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "MavenJavadocNonAsciiRecipe(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenJavadocNonAsciiRecipe)) {
            return false;
        }
        MavenJavadocNonAsciiRecipe other = (MavenJavadocNonAsciiRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MavenJavadocNonAsciiRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

