/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;

public class WhileInsteadOfFor
extends Recipe {
    final String displayName = "Prefer `while` over `for` loops";
    final String description = "When only the condition expression is defined in a for loop, and the initialization and increment expressions are missing, a while loop should be used instead to increase readability.";
    final Set<String> tags = Collections.singleton("RSPEC-S1264");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            final JavaTemplate whileLoop = JavaTemplate.builder((String)"while(#{any(boolean)}) {}").build();

            public J visitForLoop(J.ForLoop forLoop, ExecutionContext ctx) {
                if (forLoop.getControl().getInit().get(0) instanceof J.Empty && forLoop.getControl().getUpdate().get(0) instanceof J.Empty && !(forLoop.getControl().getCondition() instanceof J.Empty)) {
                    J.WhileLoop w = (J.WhileLoop)this.whileLoop.apply(this.getCursor(), forLoop.getCoordinates().replace(), new Object[]{forLoop.getControl().getCondition()});
                    return w.withBody(forLoop.getBody());
                }
                return super.visitForLoop(forLoop, (Object)ctx);
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

