/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class UsePortableNewlines
extends Recipe {
    private static final MethodMatcher STRING_FORMATTED = new MethodMatcher("java.lang.String formatted(..)");
    private static final MethodMatcher STRING_FORMAT = new MethodMatcher("java.lang.String format(java.lang.String, ..)");
    private static final MethodMatcher PRINT_STREAM_PRINTF = new MethodMatcher("java.io.PrintStream printf(java.lang.String, ..)");
    private static final MethodMatcher PRINT_WRITER_PRINTF = new MethodMatcher("java.io.PrintWriter printf(java.lang.String, ..)");
    private static final MethodMatcher FORMATTER_FORMAT = new MethodMatcher("java.util.Formatter format(java.lang.String, ..)");
    private static final MethodMatcher CONSOLE_PRINTF = new MethodMatcher("java.io.Console printf(java.lang.String, ..)");
    private final String displayName = "Use %n instead of \\n in format strings";
    private final String description = "Format strings should use %n rather than \\n to produce platform-specific line separators.";
    private final Set<String> tags = Collections.singleton("RSPEC-S3457");
    private final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(STRING_FORMATTED), new UsesMethod(STRING_FORMAT), new UsesMethod(PRINT_STREAM_PRINTF), new UsesMethod(PRINT_WRITER_PRINTF), new UsesMethod(FORMATTER_FORMAT), new UsesMethod(CONSOLE_PRINTF)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (STRING_FORMATTED.matches((MethodCall)method) && method.getSelect() != null) {
                    return method.withSelect(UsePortableNewlines.replaceNewlineInLiteral(method.getSelect()));
                }
                if (STRING_FORMAT.matches((MethodCall)method) || PRINT_STREAM_PRINTF.matches((MethodCall)method) || PRINT_WRITER_PRINTF.matches((MethodCall)method) || FORMATTER_FORMAT.matches((MethodCall)method) || CONSOLE_PRINTF.matches((MethodCall)method)) {
                    return method.withArguments(ListUtils.mapFirst((List)method.getArguments(), x$0 -> UsePortableNewlines.replaceNewlineInLiteral(x$0)));
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    private static Expression replaceNewlineInLiteral(Expression maybeLiteral) {
        J.Literal literal;
        if (maybeLiteral instanceof J.Literal && (literal = (J.Literal)maybeLiteral).getValue() instanceof String && literal.getValueSource() != null) {
            String source = literal.getValueSource();
            String value = (String)literal.getValue();
            if (source.contains("\\n")) {
                return literal.withValue((Object)value.replace("\n", "%n")).withValueSource(source.replace("\\n", "%n"));
            }
        }
        return maybeLiteral;
    }

    @Generated
    public UsePortableNewlines() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @Generated
    public String toString() {
        return "UsePortableNewlines(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ", estimatedEffortPerOccurrence=" + this.getEstimatedEffortPerOccurrence() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UsePortableNewlines)) {
            return false;
        }
        UsePortableNewlines other = (UsePortableNewlines)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Duration this$estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        Duration other$estimatedEffortPerOccurrence = other.getEstimatedEffortPerOccurrence();
        return !(this$estimatedEffortPerOccurrence == null ? other$estimatedEffortPerOccurrence != null : !((Object)this$estimatedEffortPerOccurrence).equals(other$estimatedEffortPerOccurrence));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UsePortableNewlines;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Duration $estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        result = result * 59 + ($estimatedEffortPerOccurrence == null ? 43 : ((Object)$estimatedEffortPerOccurrence).hashCode());
        return result;
    }
}

