/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Repeat;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

public class UnwrapElseAfterReturn
extends Recipe {
    final String displayName = "Unwrap else block after return or throw statement";
    final String description = "Unwraps the else block when the if block ends with a return or throw statement, reducing nesting and improving code readability.";
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(1L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){

            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block b = (J.Block)this.visitAndCast((Tree)block, ctx, (x$0, x$1) -> super.visitBlock(x$0, x$1));
                AtomicReference<Object> endWhitespace = new AtomicReference<Object>(null);
                J.Block alteredBlock = b.withStatements(ListUtils.flatMap((List)b.getStatements(), statement -> {
                    J.If ifStatement;
                    if (statement instanceof J.If && (ifStatement = (J.If)statement).getElsePart() != null && this.endsWithReturnOrThrow(ifStatement.getThenPart())) {
                        J.If newIf = ifStatement.withElsePart(null);
                        Statement elsePart = ifStatement.getElsePart().getBody();
                        if (elsePart instanceof J.Block) {
                            J.Block elseBlock = (J.Block)elsePart;
                            endWhitespace.set(elseBlock.getEnd());
                            return ListUtils.concat((Object)newIf, (List)ListUtils.mapFirst((List)elseBlock.getStatements(), elseStmt -> {
                                List elseComments = elseBlock.getPrefix().getComments();
                                List stmtComments = elseStmt.getPrefix().getComments();
                                if (!elseComments.isEmpty() || !stmtComments.isEmpty()) {
                                    return (Statement)elseStmt.withComments(ListUtils.concatAll((List)elseComments, (List)stmtComments));
                                }
                                String whitespace = ifStatement.getElsePart().getPrefix().getWhitespace();
                                return (Statement)elseStmt.withPrefix(elseStmt.getPrefix().withWhitespace(whitespace));
                            }));
                        }
                        return Arrays.asList(newIf, (Statement)elsePart.withPrefix(ifStatement.getElsePart().getPrefix()));
                    }
                    return statement;
                }));
                if (endWhitespace.get() != null) {
                    List mergedComments = ListUtils.concatAll((List)((Space)endWhitespace.get()).getComments(), (List)b.getEnd().getComments());
                    alteredBlock = alteredBlock.withEnd(b.getEnd().withComments(mergedComments).withWhitespace(((Space)endWhitespace.get()).getWhitespace()));
                }
                return (J.Block)this.maybeAutoFormat((J)b, (J)alteredBlock, ctx);
            }

            private boolean endsWithReturnOrThrow(Statement statement) {
                J.Block block;
                if (statement instanceof J.Return || statement instanceof J.Throw) {
                    return true;
                }
                if (statement instanceof J.Block && !(block = (J.Block)statement).getStatements().isEmpty()) {
                    Statement lastStatement = (Statement)block.getStatements().get(block.getStatements().size() - 1);
                    return lastStatement instanceof J.Return || lastStatement instanceof J.Throw;
                }
                return false;
            }
        };
        return Repeat.repeatUntilStable((TreeVisitor)javaVisitor);
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

