/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.NoMissingTypes;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public final class UnnecessaryCatch
extends Recipe {
    @Option(displayName="Include `java.lang.Exception`", description="Whether to include `java.lang.Exception` in the list of checked exceptions to remove. Unlike other checked exceptions, `java.lang.Exception` is also the superclass of unchecked exceptions. So removing `catch(Exception e)` may result in changed runtime behavior in the presence of unchecked exceptions. Default `false`", required=false)
    private final boolean includeJavaLangException;
    @Option(displayName="Include `java.lang.Throwable`", description="Whether to include `java.lang.Throwable` in the list of exceptions to remove. Unlike other checked exceptions, `java.lang.Throwable` is also the superclass of unchecked exceptions. So removing `catch(Throwable e)` may result in changed runtime behavior in the presence of unchecked exceptions. Default `false`", required=false)
    private final boolean includeJavaLangThrowable;
    private final String displayName = "Remove catch for a checked exception if the try block does not throw that exception";
    private final String description = "A refactoring operation may result in a checked exception that is no longer thrown from a `try` block. This recipe will find and remove unnecessary catch blocks.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new NoMissingTypes(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private static final String JAVA_LANG_EXCEPTION = "java.lang.Exception";
            private static final String JAVA_LANG_ERROR = "java.lang.Error";
            private static final String JAVA_LANG_RUNTIME_EXCEPTION = "java.lang.RuntimeException";
            private static final String JAVA_LANG_THROWABLE = "java.lang.Throwable";

            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block b = super.visitBlock(block, (Object)ctx);
                return b.withStatements(ListUtils.flatMap((List)b.getStatements(), statement -> {
                    J.Try aTry;
                    if (statement instanceof J.Try && (aTry = (J.Try)statement).getCatches().isEmpty() && aTry.getResources() == null && aTry.getFinally() == null) {
                        return ListUtils.map((List)aTry.getBody().getStatements(), tryStat -> (Statement)this.autoFormat((J)tryStat, ctx, this.getCursor()));
                    }
                    return statement;
                }));
            }

            public J.Try visitTry(J.Try tryable, ExecutionContext ctx) {
                J.Try t = super.visitTry(tryable, (Object)ctx);
                if (t.getResources() != null) {
                    return t;
                }
                final ArrayList<JavaType> thrownExceptions = new ArrayList<JavaType>();
                new JavaIsoVisitor<Integer>(){

                    public J.NewClass visitNewClass(J.NewClass newClass, Integer integer) {
                        JavaType.Method methodType = newClass.getMethodType();
                        if (methodType != null) {
                            thrownExceptions.addAll(methodType.getThrownExceptions());
                        }
                        return super.visitNewClass(newClass, (Object)integer);
                    }

                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Integer integer) {
                        JavaType.Method methodType = method.getMethodType();
                        if (methodType != null) {
                            thrownExceptions.addAll(methodType.getThrownExceptions());
                        }
                        return super.visitMethodInvocation(method, (Object)integer);
                    }

                    public J.Throw visitThrow(J.Throw thrown, Integer integer) {
                        JavaType type = thrown.getException().getType();
                        if (type != null) {
                            thrownExceptions.add(type);
                        }
                        return super.visitThrow(thrown, (Object)integer);
                    }
                }.visit((Tree)t.getBody(), (Object)0);
                Set<JavaType> unnecessaryTypes = this.getUnnecessaryTypes(t, thrownExceptions);
                if (unnecessaryTypes.isEmpty()) {
                    return t;
                }
                for (JavaType type : unnecessaryTypes) {
                    this.maybeRemoveImport(TypeUtils.asFullyQualified((JavaType)type));
                }
                return t.withCatches(ListUtils.map((List)t.getCatches(), (i, aCatch) -> {
                    J.ControlParentheses parameter = aCatch.getParameter();
                    TypeTree typeExpression = ((J.VariableDeclarations)aCatch.getParameter().getTree()).getTypeExpression();
                    if (typeExpression instanceof J.MultiCatch) {
                        J.MultiCatch multiCatch = (J.MultiCatch)typeExpression;
                        List alternatives = ListUtils.map((List)multiCatch.getAlternatives(), typeTree -> typeTree != null && unnecessaryTypes.contains(typeTree.getType()) ? null : typeTree);
                        if (alternatives.isEmpty()) {
                            return null;
                        }
                        List leftTrimmed = ListUtils.mapFirst((List)alternatives, first -> (NameTree)first.withPrefix(((NameTree)multiCatch.getAlternatives().get(0)).getPrefix()));
                        J.MultiCatch.Padding padding = multiCatch.withAlternatives(leftTrimmed).getPadding();
                        List rightTrimmed = ListUtils.mapLast((List)padding.getAlternatives(), last -> last.withAfter(Space.EMPTY));
                        return aCatch.withParameter(aCatch.getParameter().withTree((J)((J.VariableDeclarations)aCatch.getParameter().getTree()).withTypeExpression((TypeTree)padding.withAlternatives(rightTrimmed))));
                    }
                    if (unnecessaryTypes.contains(parameter.getType())) {
                        return null;
                    }
                    return aCatch;
                }));
            }

            private Set<JavaType> getUnnecessaryTypes(J.Try aTry, Collection<JavaType> thrownExceptions) {
                HashSet<JavaType> caughtExceptions = new HashSet<JavaType>();
                for (J.Try.Catch c : aTry.getCatches()) {
                    JavaType type = c.getParameter().getType();
                    if (type == null) continue;
                    if (type instanceof JavaType.MultiCatch) {
                        for (JavaType throwable : ((JavaType.MultiCatch)type).getThrowableTypes()) {
                            if (!this.isCheckedException(throwable) && !this.isGenericTypeRemovableByOption(throwable)) continue;
                            caughtExceptions.add(throwable);
                        }
                        continue;
                    }
                    if (!this.isCheckedException(type) && !this.isGenericTypeRemovableByOption(type)) continue;
                    caughtExceptions.add(c.getParameter().getType());
                }
                HashSet<JavaType> unnecessaryExceptions = new HashSet<JavaType>(caughtExceptions);
                unnecessaryExceptions.removeAll(thrownExceptions);
                HashSet<JavaType> toKeep = new HashSet<JavaType>();
                block2: for (JavaType caughtException : unnecessaryExceptions) {
                    if (this.isGenericTypeRemovableByOption(caughtException)) continue;
                    for (JavaType thrownException : thrownExceptions) {
                        if (!TypeUtils.isAssignableTo((JavaType)thrownException, (JavaType)caughtException) && !TypeUtils.isAssignableTo((JavaType)caughtException, (JavaType)thrownException)) continue;
                        toKeep.add(caughtException);
                        continue block2;
                    }
                }
                unnecessaryExceptions.removeAll(toKeep);
                return unnecessaryExceptions;
            }

            private boolean isGenericTypeRemovableByOption(JavaType type) {
                if (UnnecessaryCatch.this.includeJavaLangException && TypeUtils.isOfClassType((JavaType)type, (String)JAVA_LANG_EXCEPTION)) {
                    return true;
                }
                return UnnecessaryCatch.this.includeJavaLangThrowable && TypeUtils.isOfClassType((JavaType)type, (String)JAVA_LANG_THROWABLE);
            }

            private boolean isCheckedException(JavaType type) {
                if (!(type instanceof JavaType.Class)) {
                    return false;
                }
                JavaType.Class exceptionClass = (JavaType.Class)type;
                return TypeUtils.isAssignableTo((String)JAVA_LANG_EXCEPTION, (JavaType)exceptionClass) && !TypeUtils.isAssignableTo((String)JAVA_LANG_RUNTIME_EXCEPTION, (JavaType)exceptionClass) && !TypeUtils.isAssignableTo((String)JAVA_LANG_ERROR, (JavaType)exceptionClass) && !TypeUtils.isOfClassType((JavaType)exceptionClass, (String)JAVA_LANG_EXCEPTION) && !TypeUtils.isOfClassType((JavaType)exceptionClass, (String)JAVA_LANG_THROWABLE);
            }
        });
    }

    @Generated
    public UnnecessaryCatch(boolean includeJavaLangException, boolean includeJavaLangThrowable) {
        this.includeJavaLangException = includeJavaLangException;
        this.includeJavaLangThrowable = includeJavaLangThrowable;
    }

    @Generated
    public boolean isIncludeJavaLangException() {
        return this.includeJavaLangException;
    }

    @Generated
    public boolean isIncludeJavaLangThrowable() {
        return this.includeJavaLangThrowable;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "UnnecessaryCatch(includeJavaLangException=" + this.isIncludeJavaLangException() + ", includeJavaLangThrowable=" + this.isIncludeJavaLangThrowable() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnnecessaryCatch)) {
            return false;
        }
        UnnecessaryCatch other = (UnnecessaryCatch)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isIncludeJavaLangException() != other.isIncludeJavaLangException()) {
            return false;
        }
        if (this.isIncludeJavaLangThrowable() != other.isIncludeJavaLangThrowable()) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UnnecessaryCatch;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeJavaLangException() ? 79 : 97);
        result = result * 59 + (this.isIncludeJavaLangThrowable() ? 79 : 97);
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

