/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.staticanalysis.LambdaBlockToExpression;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

@Incubating(since="7.23.0")
public class RemoveRedundantTypeCast
extends Recipe {
    private static final String REMOVE_UNNECESSARY_PARENTHESES = "removeUnnecessaryParentheses";
    final String displayName = "Remove redundant casts";
    final String description = "Removes unnecessary type casts. Does not currently check casts in lambdas and class constructors.";
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);
    final Set<String> tags = Collections.singleton("RSPEC-S1905");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not(new KotlinFileChecker()), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitTypeCast(J.TypeCast typeCast, ExecutionContext ctx) {
                JavaType.Method methodType;
                J visited = super.visitTypeCast(typeCast, (Object)ctx);
                if (!(visited instanceof J.TypeCast)) {
                    return visited;
                }
                Cursor parent = this.getCursor().dropParentUntil(is -> is instanceof J.VariableDeclarations || is instanceof J.Lambda || is instanceof J.Return || is instanceof MethodCall || is instanceof J.MethodDeclaration || is instanceof J.ClassDeclaration || is instanceof JavaSourceFile);
                J parentValue = (J)parent.getValue();
                J.TypeCast visitedTypeCast = (J.TypeCast)visited;
                JavaType expressionType = visitedTypeCast.getExpression().getType();
                JavaType castType = visitedTypeCast.getType();
                JavaType targetType = null;
                if (castType.equals((Object)expressionType)) {
                    targetType = castType;
                } else if (parentValue instanceof J.VariableDeclarations) {
                    targetType = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)parentValue).getVariables().get(0)).getType();
                } else if (parentValue instanceof MethodCall) {
                    MethodCall methodCall = (MethodCall)parentValue;
                    JavaType.Method methodType2 = methodCall.getMethodType();
                    if (methodType2 == null || LambdaBlockToExpression.hasMethodOverloading(methodType2)) {
                        return visited;
                    }
                    if (!methodType2.getParameterTypes().isEmpty()) {
                        List arguments = methodCall.getArguments();
                        for (int i = 0; i < arguments.size(); ++i) {
                            Expression arg = (Expression)arguments.get(i);
                            if (arg != typeCast) continue;
                            targetType = this.getParameterType(methodType2, i);
                            break;
                        }
                    }
                    if (TypeUtils.isAssignableTo((JavaType)castType, (JavaType)expressionType)) {
                        targetType = castType;
                    }
                } else if (parentValue instanceof J.Return && this.expressionIsTypeCast((J.Return)parentValue, typeCast) && (parent = parent.dropParentUntil(is -> is instanceof J.Lambda || is instanceof J.MethodDeclaration || is instanceof J.ClassDeclaration || is instanceof JavaSourceFile)).getValue() instanceof J.MethodDeclaration && ((J.MethodDeclaration)parent.getValue()).getMethodType() != null) {
                    methodType = ((J.MethodDeclaration)parent.getValue()).getMethodType();
                    targetType = methodType.getReturnType();
                }
                if (targetType == null) {
                    return visitedTypeCast;
                }
                if ((targetType instanceof JavaType.Primitive || castType instanceof JavaType.Primitive) && castType != expressionType) {
                    return visitedTypeCast;
                }
                if (typeCast.getExpression() instanceof J.Lambda || typeCast.getExpression() instanceof J.MemberReference) {
                    return visitedTypeCast;
                }
                if (parentValue instanceof J.MethodInvocation && TypeUtils.isAssignableTo((JavaType)castType, (JavaType)expressionType) && !castType.equals((Object)expressionType) && (methodType = ((J.MethodInvocation)parentValue).getMethodType()) != null && methodType.getReturnType() instanceof JavaType.Parameterized) {
                    return visitedTypeCast;
                }
                if (!(targetType instanceof JavaType.Array) && TypeUtils.isOfClassType((JavaType)targetType, (String)"java.lang.Object") || TypeUtils.isOfType((JavaType)targetType, (JavaType)expressionType) || TypeUtils.isAssignableTo((JavaType)targetType, (JavaType)expressionType)) {
                    Cursor directParent;
                    JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified((JavaType)castType);
                    if (fullyQualified != null) {
                        this.maybeRemoveImport(fullyQualified.getFullyQualifiedName());
                    }
                    if ((directParent = this.getCursor().getParent()) != null && directParent.getParent() != null && directParent.getParent().getValue() instanceof J.Parentheses) {
                        directParent.getParent().putMessage(RemoveRedundantTypeCast.REMOVE_UNNECESSARY_PARENTHESES, (Object)true);
                    }
                    return visitedTypeCast.getExpression().withPrefix(visitedTypeCast.getPrefix());
                }
                return visitedTypeCast;
            }

            public <T extends J> J visitParentheses(J.Parentheses<T> parens, ExecutionContext ctx) {
                J.Parentheses parentheses = (J.Parentheses)super.visitParentheses(parens, (Object)ctx);
                if (((Boolean)this.getCursor().getMessage(RemoveRedundantTypeCast.REMOVE_UNNECESSARY_PARENTHESES, (Object)false)).booleanValue()) {
                    return parentheses.getTree().withPrefix(parentheses.getPrefix());
                }
                return parentheses;
            }

            private JavaType getParameterType(JavaType.Method method, int arg) {
                List parameterTypes = method.getParameterTypes();
                if (parameterTypes.size() > arg) {
                    return (JavaType)parameterTypes.get(arg);
                }
                JavaType type = (JavaType)parameterTypes.get(parameterTypes.size() - 1);
                return type instanceof JavaType.Array ? ((JavaType.Array)type).getElemType() : type;
            }

            private boolean expressionIsTypeCast(J.Return return_, J.TypeCast typeCast) {
                if (return_.getExpression() instanceof J.Parentheses) {
                    return this.expressionIsTypeCast((J.Parentheses)return_.getExpression(), typeCast);
                }
                return return_.getExpression() == typeCast;
            }

            private boolean expressionIsTypeCast(J.Parentheses<?> parentheses, J.TypeCast typeCast) {
                if (parentheses.getTree() instanceof J.Parentheses) {
                    return this.expressionIsTypeCast((J.Parentheses)parentheses.getTree(), typeCast);
                }
                return parentheses.getTree() == typeCast;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

