/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.Javadoc;

public class RemoveJavaDocAuthorTag
extends Recipe {
    final String displayName = "Remove author tags from JavaDocs";
    final String description = "Removes author tags from JavaDocs to reduce code maintenance.";
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            protected JavadocVisitor<ExecutionContext> getJavadocVisitor() {
                return new JavadocVisitor<ExecutionContext>((JavaVisitor)this){

                    public Javadoc visitDocComment(Javadoc.DocComment javadoc, ExecutionContext ctx) {
                        Javadoc.DocComment dc = (Javadoc.DocComment)super.visitDocComment(javadoc, (Object)ctx);
                        ArrayList<Javadoc> newBody = new ArrayList<Javadoc>();
                        boolean isChanged = false;
                        boolean removeNextLineBreak = false;
                        for (int i = javadoc.getBody().size() - 1; i >= 0; --i) {
                            Javadoc doc = (Javadoc)javadoc.getBody().get(i);
                            if (removeNextLineBreak) {
                                if (!(doc instanceof Javadoc.LineBreak)) continue;
                                removeNextLineBreak = false;
                                continue;
                            }
                            if (doc instanceof Javadoc.Author) {
                                isChanged = true;
                                removeNextLineBreak = true;
                                continue;
                            }
                            newBody.add(doc);
                        }
                        if (isChanged) {
                            if (RemoveJavaDocAuthorTag.isBlank(this.getCursor(), newBody)) {
                                return null;
                            }
                            Collections.reverse(newBody);
                            dc = dc.withBody(newBody);
                        }
                        return dc;
                    }
                };
            }
        };
    }

    static boolean isBlank(Cursor cursor, List<Javadoc> newBody) {
        return newBody.stream().allMatch(jd -> {
            PrintOutputCapture p = new PrintOutputCapture(null);
            jd.printer(cursor).visit((Tree)jd, (Object)p);
            String currentLine = p.getOut().trim();
            return StringUtils.isBlank((String)currentLine) || "*".equals(currentLine);
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

