/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.MethodCall;

public class PreferSystemGetPropertyOverGetenv
extends Recipe {
    private static final MethodMatcher GETENV = new MethodMatcher("java.lang.System getenv(java.lang.String)");
    private static final Map<String, String> ENV_TO_PROPERTY = new HashMap<String, String>();
    final String displayName = "Prefer `System.getProperty(\"user.home\")` over `System.getenv(\"HOME\")`";
    final String description = "Replaces `System.getenv(\"HOME\")` with `System.getProperty(\"user.home\")` for better portability.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(GETENV), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (GETENV.matches((MethodCall)method) && method.getArguments().get(0) instanceof J.Literal) {
                    String value = (String)((J.Literal)method.getArguments().get(0)).getValue();
                    String replacementProperty = (String)ENV_TO_PROPERTY.get(value);
                    if (replacementProperty != null) {
                        return (J.MethodInvocation)JavaTemplate.apply((String)("System.getProperty(\"" + replacementProperty + "\")"), (Cursor)this.getCursor(), (JavaCoordinates)method.getCoordinates().replace(), (Object[])new Object[0]);
                    }
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    static {
        ENV_TO_PROPERTY.put("USER", "user.name");
        ENV_TO_PROPERTY.put("USERNAME", "user.name");
        ENV_TO_PROPERTY.put("HOME", "user.home");
        ENV_TO_PROPERTY.put("USERPROFILE", "user.home");
        ENV_TO_PROPERTY.put("TMPDIR", "java.io.tmpdir");
        ENV_TO_PROPERTY.put("TEMP", "java.io.tmpdir");
        ENV_TO_PROPERTY.put("TMP", "java.io.tmpdir");
    }
}

